/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.ServletContextResource;

public class StaticWebApplicationContext
extends StaticApplicationContext
implements ConfigurableWebApplicationContext {
    private ServletContext servletContext;
    private String namespace;
    private ThemeSource themeSource;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] configLocations) {
        throw new UnsupportedOperationException("StaticWebApplicationContext does not support configLocations");
    }

    public void refresh() throws BeansException {
        if (this.namespace != null) {
            this.setDisplayName("StaticWebApplicationContext for namespace '" + this.namespace + "'");
        } else {
            this.setDisplayName("Root StaticWebApplicationContext");
        }
        super.refresh();
    }

    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }
}

