/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.cos;

import com.oreilly.servlet.MultipartRequest;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.cos.CosMultipartHttpServletRequest;
import org.springframework.web.util.WebUtils;

public class CosMultipartResolver
extends WebApplicationObjectSupport
implements MultipartResolver {
    public static final String MULTIPART_CONTENT_TYPE = "multipart/form-data";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int maxUploadSize = Integer.MAX_VALUE;
    private String headerEncoding;
    private File uploadTempDir;

    public CosMultipartResolver() {
    }

    public CosMultipartResolver(ServletContext servletContext) {
        this.uploadTempDir = WebUtils.getTempDir(servletContext);
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    protected int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setHeaderEncoding(String headerEncoding) {
        this.headerEncoding = headerEncoding;
    }

    protected String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.uploadTempDir = uploadTempDir.getFile();
    }

    protected File getUploadTempDir() {
        return this.uploadTempDir;
    }

    protected void initApplicationContext() {
        if (this.uploadTempDir == null) {
            this.uploadTempDir = this.getTempDir();
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().startsWith(MULTIPART_CONTENT_TYPE);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        try {
            MultipartRequest multipartRequest = this.newMultipartRequest(request);
            if (this.logger.isDebugEnabled()) {
                Enumeration fileNames = multipartRequest.getFileNames();
                while (fileNames.hasMoreElements()) {
                    String fileName = (String)fileNames.nextElement();
                    File file = multipartRequest.getFile(fileName);
                    this.logger.debug((Object)("Found multipart file '" + fileName + "' of size " + (file != null ? file.length() : 0L) + " bytes with original file name [" + multipartRequest.getOriginalFileName(fileName) + "], " + (file != null ? "stored at [" + file.getAbsolutePath() + "]" : "empty")));
                }
            }
            return new CosMultipartHttpServletRequest(request, multipartRequest);
        }
        catch (IOException ex) {
            throw new MultipartException("Could not parse multipart request", ex);
        }
    }

    protected MultipartRequest newMultipartRequest(HttpServletRequest request) throws IOException {
        String tempPath = this.uploadTempDir.getAbsolutePath();
        return this.headerEncoding != null ? new MultipartRequest(request, tempPath, this.maxUploadSize, this.headerEncoding) : new MultipartRequest(request, tempPath, this.maxUploadSize);
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        MultipartRequest multipartRequest = ((CosMultipartHttpServletRequest)request).getMultipartRequest();
        Enumeration fileNames = multipartRequest.getFileNames();
        while (fileNames.hasMoreElements()) {
            String fileName = (String)fileNames.nextElement();
            File file = multipartRequest.getFile(fileName);
            if (file == null) continue;
            if (file.exists()) {
                if (file.delete()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Cleaned up multipart file '" + fileName + "' with original file name [" + multipartRequest.getOriginalFileName(fileName) + "], stored at [" + file.getAbsolutePath() + "]"));
                    continue;
                }
                this.logger.warn((Object)("Could not delete multipart file '" + fileName + "' with original file name [" + multipartRequest.getOriginalFileName(fileName) + "], stored at [" + file.getAbsolutePath() + "]"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Multipart file '" + fileName + "' with original file name [" + multipartRequest.getOriginalFileName(fileName) + "] has already been moved - no cleanup necessary"));
        }
    }
}

