/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.JdoCallback;
import org.springframework.orm.jdo.JdoOperations;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoTemplate
extends JdoAccessor
implements JdoOperations {
    private boolean allowCreate = true;

    public JdoTemplate() {
    }

    public JdoTemplate(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
        this.afterPropertiesSet();
    }

    public JdoTemplate(PersistenceManagerFactory pmf, boolean allowCreate) {
        this.setPersistenceManagerFactory(pmf);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object execute(JdoCallback action) throws DataAccessException {
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), this.isAllowCreate());
        boolean existingTransaction = TransactionSynchronizationManager.hasResource((Object)this.getPersistenceManagerFactory());
        try {
            Object result = action.doInJdo(pm);
            this.flushIfNecessary(pm, existingTransaction);
            Object object = result;
            return object;
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
        }
    }

    public Collection executeFind(JdoCallback action) throws DataAccessException {
        return (Collection)this.execute(action);
    }

    public Object getObjectById(final Serializable objectId) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.getObjectById((Object)objectId, true);
            }
        });
    }

    public Object getObjectById(final Class entityClass, final Serializable idValue) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Object oid = pm.newObjectIdInstance(entityClass, idValue.toString());
                return pm.getObjectById(oid, true);
            }
        });
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evict(entity);
                return null;
            }
        });
    }

    public void evictAll() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evictAll();
                return null;
            }
        });
    }

    public void refresh(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refresh(entity);
                return null;
            }
        });
    }

    public void refreshAll() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refreshAll();
                return null;
            }
        });
    }

    public void makePersistent(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.makePersistent(entity);
                return null;
            }
        });
    }

    public void deletePersistent(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistent(entity);
                return null;
            }
        });
    }

    public void deletePersistentAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistentAll(entities);
                return null;
            }
        });
    }

    public void flush() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                JdoTemplate.this.getJdoDialect().flush(pm);
                return null;
            }
        });
    }

    public Collection find(final Class entityClass) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass);
                JdoTemplate.this.prepareQuery(query);
                return query.execute();
            }
        });
    }

    public Collection find(final Class entityClass, final String filter) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                JdoTemplate.this.prepareQuery(query);
                return query.execute();
            }
        });
    }

    public Collection find(final Class entityClass, final String filter, final String ordering) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                query.setOrdering(ordering);
                JdoTemplate.this.prepareQuery(query);
                return query.execute();
            }
        });
    }

    public Collection find(final Class entityClass, final String filter, final String parameters, final Object[] values) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                query.declareParameters(parameters);
                JdoTemplate.this.prepareQuery(query);
                return query.executeWithArray(values);
            }
        });
    }

    public Collection find(final Class entityClass, final String filter, final String parameters, final Object[] values, final String ordering) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                query.declareParameters(parameters);
                query.setOrdering(ordering);
                JdoTemplate.this.prepareQuery(query);
                return query.executeWithArray(values);
            }
        });
    }

    public Collection find(final Class entityClass, final String filter, final String parameters, final Map values) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                query.declareParameters(parameters);
                JdoTemplate.this.prepareQuery(query);
                return query.executeWithMap(values);
            }
        });
    }

    public Collection find(final Class entityClass, final String filter, final String parameters, final Map values, final String ordering) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                query.declareParameters(parameters);
                query.setOrdering(ordering);
                JdoTemplate.this.prepareQuery(query);
                return query.executeWithMap(values);
            }
        });
    }

    public void prepareQuery(Query query) throws JDOException {
        PersistenceManagerFactoryUtils.applyTransactionTimeout(query, this.getPersistenceManagerFactory(), this.getJdoDialect());
    }
}

