/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class LocalPersistenceManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Properties jdoProperties;
    private PersistenceManagerFactory persistenceManagerFactory;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setJdoProperties(Properties jdoProperties) {
        this.jdoProperties = jdoProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IllegalArgumentException, IOException, JDOException {
        if (this.configLocation == null && this.jdoProperties == null) {
            throw new IllegalArgumentException("Either configLocation (e.g. '/kodo.properties') or jdoProperties must be set");
        }
        Properties prop = new Properties();
        if (this.configLocation != null) {
            InputStream is = this.configLocation.getInputStream();
            try {
                prop.load(is);
            }
            finally {
                is.close();
            }
        }
        if (this.jdoProperties != null) {
            prop.putAll((Map<?, ?>)this.jdoProperties);
        }
        this.persistenceManagerFactory = this.newPersistenceManagerFactory(prop);
    }

    protected PersistenceManagerFactory newPersistenceManagerFactory(Properties prop) {
        return JDOHelper.getPersistenceManagerFactory((Properties)prop);
    }

    public Object getObject() {
        return this.persistenceManagerFactory;
    }

    public Class getObjectType() {
        return this.persistenceManagerFactory != null ? this.persistenceManagerFactory.getClass() : (class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = LocalPersistenceManagerFactoryBean.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)("Closing JDO PersistenceManagerFactory of LocalPersistenceManagerFactoryBean [" + this + "]"));
        this.persistenceManagerFactory.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

