/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public abstract class AbstractSpringContextTests
extends TestCase {
    private static Map contextKeyToContextMap = new HashMap();
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void setDirty(String[] locations) {
        contextKeyToContextMap.remove(this.contextKeyString(locations));
    }

    protected boolean hasCachedContext(Object contextKey) {
        return contextKeyToContextMap.containsKey(contextKey);
    }

    protected String contextKeyString(Object contextKey) {
        if (contextKey instanceof String[]) {
            return StringUtils.arrayToCommaDelimitedString((Object[])((String[])contextKey));
        }
        return contextKey.toString();
    }

    protected ConfigurableApplicationContext getContext(Object key) {
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)contextKeyToContextMap.get(this.contextKeyString(key));
        if (ctx == null) {
            ctx = key instanceof String[] ? this.loadContextLocations((String[])key) : this.loadContext(key);
            contextKeyToContextMap.put(this.contextKeyString(key), ctx);
        }
        return ctx;
    }

    protected ConfigurableApplicationContext loadContextLocations(String[] locations) {
        this.logger.info((Object)("Loading config for " + StringUtils.arrayToCommaDelimitedString((Object[])locations)));
        return new ClassPathXmlApplicationContext(locations);
    }

    protected ConfigurableApplicationContext loadContext(Object key) {
        throw new UnsupportedOperationException("Subclasses may override this");
    }
}

