/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.MockHttpServletResponse;

public class MockRequestDispatcher
implements RequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String url;

    public MockRequestDispatcher(String url) {
        this.url = url;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!(servletResponse instanceof MockHttpServletResponse)) {
            throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
        }
        ((MockHttpServletResponse)servletResponse).setForwardedUrl(this.url);
        this.logger.info((Object)("RequestDispatcher: forwarding to URL [" + this.url + "]"));
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (!(servletResponse instanceof MockHttpServletResponse)) {
            throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
        }
        ((MockHttpServletResponse)servletResponse).setIncludedUrl(this.url);
        this.logger.info((Object)("RequestDispatcher: including URL [" + this.url + "]"));
    }
}

