/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.support.AopUtils;
import org.springframework.metadata.Attributes;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class AttributesTransactionAttributeSource
implements TransactionAttributeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Attributes attributes;

    public AttributesTransactionAttributeSource(Attributes attributes) {
        this.attributes = attributes;
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        TransactionAttribute txAtt = this.findTransactionAttribute(this.attributes.getAttributes(specificMethod));
        if (txAtt != null) {
            return txAtt;
        }
        txAtt = this.findTransactionAttribute(this.attributes.getAttributes(specificMethod.getDeclaringClass()));
        if (txAtt != null) {
            return txAtt;
        }
        if (specificMethod != method) {
            txAtt = this.findTransactionAttribute(this.attributes.getAttributes(method));
            if (txAtt != null) {
                return txAtt;
            }
            return this.findTransactionAttribute(this.attributes.getAttributes(method.getDeclaringClass()));
        }
        return null;
    }

    protected TransactionAttribute findTransactionAttribute(Collection atts) {
        if (atts == null) {
            return null;
        }
        TransactionAttribute txAttribute = null;
        Iterator itr = atts.iterator();
        while (itr.hasNext() && txAttribute == null) {
            Object att = itr.next();
            if (!(att instanceof TransactionAttribute)) continue;
            txAttribute = (TransactionAttribute)att;
        }
        if (txAttribute instanceof RuleBasedTransactionAttribute) {
            RuleBasedTransactionAttribute rbta = (RuleBasedTransactionAttribute)txAttribute;
            LinkedList l = new LinkedList();
            Iterator itr2 = atts.iterator();
            while (itr2.hasNext()) {
                Object att = itr2.next();
                if (!(att instanceof RollbackRuleAttribute)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found RollbackRule " + att));
                }
                l.add(att);
            }
            rbta.setRollbackRules(l);
        }
        return txAttribute;
    }
}

