/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.CannotCloseJdbcConnectionException;
import org.springframework.jdbc.datasource.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;

public abstract class JdbcDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JdbcTemplate jdbcTemplate;

    public final void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected final DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }

    public final void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    protected final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.jdbcTemplate == null) {
            throw new IllegalArgumentException("dataSource or jdbcTemplate is required");
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }

    protected final Connection getConnection() throws CannotGetJdbcConnectionException {
        return DataSourceUtils.getConnection(this.getDataSource());
    }

    protected final void closeConnectionIfNecessary(Connection con) throws CannotCloseJdbcConnectionException {
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
    }
}

