/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.core.RowMapper;

public class SqlParameter {
    private String name;
    private int type;
    private String typeName;

    public SqlParameter(int type) {
        this(null, type, null);
    }

    public SqlParameter(int type, String typeName) {
        this(null, type, typeName);
    }

    public SqlParameter(String name, int type) {
        this(name, type, null);
    }

    public SqlParameter(String name, int type, String typeName) {
        this.name = name;
        this.type = type;
        this.typeName = typeName;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static List sqlTypesToAnonymousParameterList(int[] types) {
        LinkedList<SqlParameter> l = new LinkedList<SqlParameter>();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                l.add(new SqlParameter(types[i]));
            }
        }
        return l;
    }

    class ResultReaderStoredProcImpl
    implements ResultReader {
        private List results;
        private RowMapper rowMapper;
        private int rowNum = 0;

        ResultReaderStoredProcImpl(int rowsExpected, RowMapper rowMapper) {
            this.results = rowsExpected > 0 ? new ArrayList(rowsExpected) : new LinkedList();
            this.rowMapper = rowMapper;
        }

        public void processRow(ResultSet rs) throws SQLException {
            this.results.add(this.rowMapper.mapRow(rs, this.rowNum++));
        }

        public List getResults() {
            return this.results;
        }
    }
}

