/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.IJdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class JdbcTemplate
extends JdbcAccessor
implements IJdbcTemplate,
InitializingBean {
    public static final PreparedStatementSetter PREPARE_STATEMENT = new PreparedStatementSetter(){

        public void setValues(PreparedStatement ps) throws SQLException {
        }
    };
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NativeJdbcExtractor nativeJdbcExtractor;
    private boolean ignoreWarnings = true;

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor extractor) {
        this.nativeJdbcExtractor = extractor;
    }

    public NativeJdbcExtractor getNativeJdbcExtractor() {
        return this.nativeJdbcExtractor;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean getIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void query(String sql, RowCallbackHandler callbackHandler) throws DataAccessException {
        this.doWithResultSetFromStaticQuery(sql, new RowCallbackHandlerResultSetExtractor(callbackHandler));
    }

    /*
     * Loose catch block
     */
    public void doWithResultSetFromStaticQuery(String sql, ResultSetExtractor rse) throws DataAccessException {
        Connection con;
        block20: {
            SQLException ignore22;
            ResultSet rs;
            Statement stmt;
            block19: {
                if (sql == null) {
                    throw new InvalidDataAccessApiUsageException("SQL may not be null");
                }
                if (this.containsBindVariables(sql)) {
                    throw new InvalidDataAccessApiUsageException("Cannot execute [" + sql + "] as a static query: it contains bind variables");
                }
                con = DataSourceUtils.getConnection(this.getDataSource());
                stmt = null;
                rs = null;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing static SQL query [" + sql + "] using a java.sql.Statement"));
                }
                Connection conToUse = con;
                if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                    conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
                }
                stmt = conToUse.createStatement();
                DataSourceUtils.applyTransactionTimeout(stmt, this.getDataSource());
                Statement stmtToUse = stmt;
                if (this.nativeJdbcExtractor != null) {
                    stmtToUse = this.nativeJdbcExtractor.getNativeStatement(stmt);
                }
                ResultSet rsToUse = rs = stmtToUse.executeQuery(sql);
                if (this.nativeJdbcExtractor != null) {
                    rsToUse = this.nativeJdbcExtractor.getNativeResultSet(rs);
                }
                rse.extractData(rsToUse);
                SQLWarning warning = stmt.getWarnings();
                this.throwExceptionOnWarningIfNotIgnoringWarnings(warning);
                Object var11_11 = null;
                if (rs == null) break block19;
                try {
                    rs.close();
                }
                catch (SQLException ignore22) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                    break block20;
                }
                catch (SQLException ignore22) {
                    // empty catch block
                }
                {
                }
            }
            break block20;
            {
                catch (SQLException ex) {
                    throw this.getExceptionTranslator().translate("JdbcTemplate.query(sql)", sql, ex);
                }
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
                throw throwable;
            }
        }
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
    }

    public void query(PreparedStatementCreator psc, RowCallbackHandler callbackHandler) throws DataAccessException {
        this.doWithResultSetFromPreparedQuery(psc, new RowCallbackHandlerResultSetExtractor(callbackHandler));
    }

    /*
     * Loose catch block
     */
    public void doWithResultSetFromPreparedQuery(PreparedStatementCreator psc, ResultSetExtractor rse) throws DataAccessException {
        Connection con;
        block18: {
            SQLException ignore22;
            ResultSet rs;
            PreparedStatement ps;
            block17: {
                con = DataSourceUtils.getConnection(this.getDataSource());
                ps = null;
                rs = null;
                Connection conToUse = con;
                if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                    conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
                }
                ps = psc.createPreparedStatement(conToUse);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing SQL query using PreparedStatement [" + psc + "]"));
                }
                PreparedStatement psToUse = ps;
                if (this.nativeJdbcExtractor != null) {
                    psToUse = this.nativeJdbcExtractor.getNativePreparedStatement(ps);
                }
                ResultSet rsToUse = rs = psToUse.executeQuery();
                if (this.nativeJdbcExtractor != null) {
                    rsToUse = this.nativeJdbcExtractor.getNativeResultSet(rs);
                }
                rse.extractData(rsToUse);
                SQLWarning warning = ps.getWarnings();
                this.throwExceptionOnWarningIfNotIgnoringWarnings(warning);
                Object var11_11 = null;
                if (rs == null) break block17;
                try {
                    rs.close();
                }
                catch (SQLException ignore22) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                    break block18;
                }
                catch (SQLException ignore22) {
                    // empty catch block
                }
                {
                }
            }
            break block18;
            {
                catch (SQLException ex) {
                    throw this.getExceptionTranslator().translate("JdbcTemplate.query with PreparedStatementCreator [" + psc + "]", null, ex);
                }
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
                throw throwable;
            }
        }
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
    }

    public void query(final String sql, final PreparedStatementSetter pss, RowCallbackHandler callbackHandler) throws DataAccessException {
        if (sql == null) {
            throw new InvalidDataAccessApiUsageException("SQL may not be null");
        }
        if (pss == null) {
            if (this.containsBindVariables(sql)) {
                throw new InvalidDataAccessApiUsageException("SQL [" + sql + "] requires at least one bind variable, but PreparedStatementSetter parameter was null");
            }
            this.query(sql, callbackHandler);
        } else {
            this.query(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement(sql);
                    DataSourceUtils.applyTransactionTimeout(ps, JdbcTemplate.this.getDataSource());
                    PreparedStatement psToUse = ps;
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        psToUse = JdbcTemplate.this.nativeJdbcExtractor.getNativePreparedStatement(ps);
                    }
                    pss.setValues(psToUse);
                    return psToUse;
                }
            }, callbackHandler);
        }
    }

    private boolean containsBindVariables(String sql) {
        return sql.indexOf("?") != -1;
    }

    public int update(final String sql) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Running SQL update [" + sql + "]"));
        }
        return this.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql);
                DataSourceUtils.applyTransactionTimeout(ps, JdbcTemplate.this.getDataSource());
                if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                    return JdbcTemplate.this.nativeJdbcExtractor.getNativePreparedStatement(ps);
                }
                return ps;
            }
        });
    }

    public int update(PreparedStatementCreator psc) throws DataAccessException {
        return this.update(new PreparedStatementCreator[]{psc})[0];
    }

    public int[] update(PreparedStatementCreator[] pscs) throws DataAccessException {
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        Statement ps = null;
        int index = 0;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            int[] retVals = new int[pscs.length];
            for (index = 0; index < retVals.length; ++index) {
                ps = pscs[index].createPreparedStatement(conToUse);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing SQL update using PreparedStatement [" + pscs[index] + "]"));
                }
                retVals[index] = ps.executeUpdate();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("SQL update affected " + retVals[index] + " rows"));
                }
                ps.close();
            }
            int[] nArray = retVals;
            return nArray;
        }
        catch (SQLException ex) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            throw this.getExceptionTranslator().translate("processing update " + (index + 1) + " of " + pscs.length + "; update was [" + pscs[index] + "]", null, ex);
        }
        finally {
            DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        }
    }

    public int update(final String sql, final PreparedStatementSetter pss) throws DataAccessException {
        if (pss == null) {
            return this.update(sql);
        }
        return this.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql);
                DataSourceUtils.applyTransactionTimeout(ps, JdbcTemplate.this.getDataSource());
                PreparedStatement psToUse = ps;
                if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                    psToUse = JdbcTemplate.this.nativeJdbcExtractor.getNativePreparedStatement(ps);
                }
                pss.setValues(psToUse);
                return ps;
            }
        });
    }

    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) throws DataAccessException {
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        Statement ps = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            ps = conToUse.prepareStatement(sql);
            DataSourceUtils.applyTransactionTimeout(ps, this.getDataSource());
            Statement psToUse = ps;
            if (this.nativeJdbcExtractor != null) {
                psToUse = this.nativeJdbcExtractor.getNativePreparedStatement((PreparedStatement)ps);
            }
            int batchSize = pss.getBatchSize();
            for (int i = 0; i < batchSize; ++i) {
                pss.setValues((PreparedStatement)psToUse, i);
                ps.addBatch();
            }
            int[] retVals = ps.executeBatch();
            ps.close();
            int[] nArray = retVals;
            return nArray;
        }
        catch (SQLException ex) {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            throw this.getExceptionTranslator().translate("processing batch update with size=" + pss.getBatchSize() + "; update was [" + sql + "]", sql, ex);
        }
        finally {
            DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        }
    }

    /*
     * Loose catch block
     */
    public Map execute(CallableStatementCreator csc, List declaredParameters) throws DataAccessException {
        HashMap hashMap;
        CallableStatement cs;
        Connection con;
        block13: {
            con = DataSourceUtils.getConnection(this.getDataSource());
            cs = null;
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            CallableStatement csToUse = cs = csc.createCallableStatement(conToUse);
            if (this.nativeJdbcExtractor != null) {
                csToUse = this.nativeJdbcExtractor.getNativeCallableStatement(cs);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing call using CallableStatement [" + cs + "]"));
            }
            boolean retVal = csToUse.execute();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("CallableStatement.execute returned [" + retVal + "]"));
            }
            HashMap retMap = new HashMap();
            if (retVal) {
                retMap.putAll(this.extractReturnedResultSets(csToUse, declaredParameters));
            }
            retMap.putAll(this.extractOutputParameters(csToUse, declaredParameters));
            hashMap = retMap;
            Object var11_11 = null;
            if (cs == null) break block13;
            try {
                cs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
        return hashMap;
        catch (SQLException ex) {
            try {
                throw this.getExceptionTranslator().translate("JdbcTemplate.execute()", csc.toString(), ex);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (cs != null) {
                    try {
                        cs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
                throw throwable;
            }
        }
    }

    private Map extractOutputParameters(CallableStatement cs, List parameters) throws SQLException {
        HashMap<String, Object> outParams = new HashMap<String, Object>();
        int sqlColIndx = 1;
        for (int i = 0; i < parameters.size(); ++i) {
            SqlParameter p = (SqlParameter)parameters.get(i);
            if (p instanceof SqlOutParameter) {
                Object out = null;
                out = cs.getObject(sqlColIndx);
                if (out instanceof ResultSet) {
                    try {
                        if (((SqlOutParameter)p).isResultSetSupported()) {
                            RowCallbackHandlerResultSetExtractor rse = null;
                            rse = ((SqlOutParameter)p).isRowMapperSupported() ? new RowCallbackHandlerResultSetExtractor(((SqlOutParameter)p).newResultReader()) : new RowCallbackHandlerResultSetExtractor(((SqlOutParameter)p).getRowCallbackHandler());
                            rse.extractData((ResultSet)out);
                            this.logger.debug((Object)"ResultSet returned from stored procedure was processed");
                            if (((SqlOutParameter)p).isRowMapperSupported()) {
                                outParams.put(p.getName(), ((ResultReader)rse.getCallbackHandler()).getResults());
                            }
                            outParams.put(p.getName(), "ResultSet processed.");
                        }
                        this.logger.warn((Object)"ResultSet returned from stored procedure but a corresponding SqlOutParameter with a RowCallbackHandler was not declared");
                        outParams.put(p.getName(), "ResultSet was returned but not processed.");
                    }
                    catch (SQLException se) {
                        throw se;
                    }
                    finally {
                        try {
                            ((ResultSet)out).close();
                        }
                        catch (SQLException ignore) {}
                    }
                } else {
                    outParams.put(p.getName(), out);
                }
            }
            if (p instanceof SqlReturnResultSet) continue;
            ++sqlColIndx;
        }
        return outParams;
    }

    private Map extractReturnedResultSets(CallableStatement cs, List parameters) throws SQLException {
        HashMap<String, Object> returnedResults = new HashMap<String, Object>();
        int rsIndx = 0;
        do {
            SqlParameter p = null;
            if (parameters != null && parameters.size() > rsIndx) {
                p = (SqlParameter)parameters.get(rsIndx);
            }
            if (p != null && p instanceof SqlReturnResultSet) {
                ResultSet rs = null;
                rs = cs.getResultSet();
                try {
                    ResultSet rsToUse = rs;
                    if (this.nativeJdbcExtractor != null) {
                        rsToUse = this.nativeJdbcExtractor.getNativeResultSet(rs);
                    }
                    RowCallbackHandlerResultSetExtractor rse = null;
                    rse = ((SqlReturnResultSet)p).isRowMapperSupported() ? new RowCallbackHandlerResultSetExtractor(((SqlReturnResultSet)p).newResultReader()) : new RowCallbackHandlerResultSetExtractor(((SqlReturnResultSet)p).getRowCallbackHandler());
                    rse.extractData(rsToUse);
                    if (((SqlReturnResultSet)p).isRowMapperSupported()) {
                        returnedResults.put(p.getName(), ((ResultReader)rse.getCallbackHandler()).getResults());
                    }
                    returnedResults.put(p.getName(), "ResultSet returned from stored procedure was processed");
                }
                catch (SQLException se) {
                    throw se;
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {}
                }
            } else {
                this.logger.warn((Object)"ResultSet returned from stored procedure but a corresponding SqlReturnResultSet parameter was not declared");
            }
            ++rsIndx;
        } while (cs.getMoreResults());
        return returnedResults;
    }

    private void throwExceptionOnWarningIfNotIgnoringWarnings(SQLWarning warning) throws SQLWarningException {
        if (warning != null) {
            if (this.ignoreWarnings) {
                this.logger.warn((Object)("SQLWarning ignored: " + warning));
            } else {
                throw new SQLWarningException("Warning not ignored", warning);
            }
        }
    }

    private static final class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private RowCallbackHandler callbackHandler;

        private RowCallbackHandlerResultSetExtractor(RowCallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        public RowCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        public void extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.callbackHandler.processRow(rs);
            }
        }
    }
}

