/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.ColumnExtractor;
import org.springframework.jdbc.core.DefaultColumnExtractor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JdbcHelper {
    private ColumnExtractor columnExtractor = new DefaultColumnExtractor();
    private JdbcTemplate jdbcTemplate;
    static /* synthetic */ Class class$java$lang$Integer;

    public JdbcHelper(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public JdbcTemplate getTemplate() {
        return this.jdbcTemplate;
    }

    public int runSQLFunction(String sql) {
        Integer I = (Integer)this.runSQLFunction(sql, class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcHelper.class$("java.lang.Integer")) : class$java$lang$Integer);
        return I;
    }

    public Object runSQLFunction(String sql, Class requiredType) throws DataAccessException {
        return this.runSQLFunction(sql, requiredType, null, null);
    }

    public int runSQLFunction(String sql, int[] types, Object[] args) {
        Integer I = (Integer)this.runSQLFunction(sql, class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcHelper.class$("java.lang.Integer")) : class$java$lang$Integer, types, args);
        return I;
    }

    public Object runSQLFunction(String sql, Class requiredType, int[] types, Object[] args) throws DataAccessException {
        FunctionHandler fh = new FunctionHandler(sql, requiredType);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sql, types);
        PreparedStatementCreator psc = pscf.newPreparedStatementCreator(args);
        this.jdbcTemplate.query(psc, (RowCallbackHandler)fh);
        return fh.getFunctionValue();
    }

    public int[] getIDs(String sql, Object[] params) throws DataAccessException {
        Object[] os = this.getIDs(sql, class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcHelper.class$("java.lang.Integer")) : class$java$lang$Integer, params);
        int[] is = new int[os.length];
        for (int i = 0; i < is.length; ++i) {
            is[i] = (Integer)os[i];
        }
        return is;
    }

    public Object[] getIDs(String sql, Class requiredType, Object[] params) throws DataAccessException {
        class IDsHandler
        extends RowCountCallbackHandler
        implements PreparedStatementCreator {
            private List l = new LinkedList();
            private final /* synthetic */ String val$sql;
            private final /* synthetic */ Object[] val$params;
            private final /* synthetic */ Class val$requiredType;

            IDsHandler(String val$sql, Object[] val$params, Class val$requiredType) {
                this.val$sql = val$sql;
                this.val$params = val$params;
                this.val$requiredType = val$requiredType;
            }

            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                PreparedStatement ps = conn.prepareStatement(this.val$sql);
                DataSourceUtils.applyTransactionTimeout(ps, JdbcHelper.this.jdbcTemplate.getDataSource());
                if (this.val$params != null) {
                    for (int i = 0; i < this.val$params.length; ++i) {
                        ps.setObject(i + 1, this.val$params[i]);
                    }
                }
                return ps;
            }

            protected void processRow(ResultSet rs, int rowNum) throws SQLException {
                this.l.add(JdbcHelper.this.columnExtractor.extractColumn(1, this.val$requiredType, rs));
            }

            public Object[] getIDs() {
                return this.l.toArray();
            }
        }
        IDsHandler idsh = new IDsHandler(sql, params, requiredType);
        this.jdbcTemplate.query(idsh, (RowCallbackHandler)idsh);
        return idsh.getIDs();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FunctionHandler
    extends RowCountCallbackHandler {
        private Object obj;
        private Class requiredType;
        private String sql;

        public FunctionHandler(String sql, Class requiredType) {
            this.requiredType = requiredType;
            this.sql = sql;
        }

        protected void processRow(ResultSet rs, int rowNum) throws SQLException {
            if (rowNum > 0) {
                throw new InvalidDataAccessResourceUsageException("runSQLFunction retrieved more than one row for sql [" + this.sql + "]: probably not a valid SQL function");
            }
            this.obj = JdbcHelper.this.columnExtractor.extractColumn(1, this.requiredType, rs);
        }

        public Object getFunctionValue() {
            return this.obj;
        }
    }
}

