/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.springframework.core.HasRootCause;

public abstract class NestedCheckedException
extends Exception
implements HasRootCause {
    private Throwable rootCause;

    public NestedCheckedException(String msg) {
        super(msg);
    }

    public NestedCheckedException(String msg, Throwable ex) {
        super(msg);
        this.rootCause = ex;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getMessage() {
        if (this.rootCause == null) {
            return super.getMessage();
        }
        return super.getMessage() + "; nested exception is: \n\t" + this.rootCause.toString();
    }

    public void printStackTrace(PrintStream ps) {
        if (this.rootCause == null) {
            super.printStackTrace(ps);
        } else {
            ps.println(this);
            this.rootCause.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.rootCause == null) {
            super.printStackTrace(pw);
        } else {
            pw.println(this);
            this.rootCause.printStackTrace(pw);
        }
    }
}

