/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public abstract class PropertiesLoaderSupport {
    public static final String XML_FILE_EXTENSION = ".xml";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties properties;
    private Resource[] locations;
    private boolean localOverride = false;
    private boolean ignoreResourceNotFound = false;
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister;
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = new Properties();
        if (this.localOverride) {
            this.loadProperties(result);
        }
        if (this.properties != null) {
            Enumeration<?> en = this.properties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                result.setProperty(key, this.properties.getProperty(key));
            }
        }
        if (!this.localOverride) {
            this.loadProperties(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                Resource location = this.locations[i];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading properties file from " + location));
                }
                InputStream is = location.getInputStream();
                try {
                    if (location.getFilename().endsWith(XML_FILE_EXTENSION)) {
                        this.propertiesPersister.loadFromXml(props, is);
                        continue;
                    }
                    if (this.fileEncoding != null) {
                        this.propertiesPersister.load(props, new InputStreamReader(is, this.fileEncoding));
                        continue;
                    }
                    this.propertiesPersister.load(props, is);
                    continue;
                }
                catch (IOException ex) {
                    if (this.ignoreResourceNotFound) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("Could not load properties from " + location + ": " + ex.getMessage()));
                        continue;
                    }
                    throw ex;
                }
                finally {
                    is.close();
                }
            }
        }
    }
}

