/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class BeanFactoryUtils {
    public static int countBeansIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesIncludingAncestors(lbf).length;
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory lbf) {
        HierarchicalBeanFactory hbf;
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(lbf.getBeanDefinitionNames()));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() != null && hbf.getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory());
            result.addAll(Arrays.asList(parentResult));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory lbf, Class type) {
        HierarchicalBeanFactory hbf;
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(lbf.getBeanDefinitionNames(type)));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() != null && hbf.getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            result.addAll(Arrays.asList(parentResult));
        }
        return result.toArray(new String[result.size()]);
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        HierarchicalBeanFactory hbf;
        HashMap result = new HashMap();
        result.putAll(lbf.getBeansOfType(type, includePrototypes, includeFactoryBeans));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() != null && hbf.getParentBeanFactory() instanceof ListableBeanFactory) {
            Map parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includePrototypes, includeFactoryBeans);
            Iterator it = parentResult.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (result.containsKey(key)) continue;
                result.put(key, parentResult.get(key));
            }
        }
        return result;
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type, includePrototypes, includeFactoryBeans);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "Expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfType(ListableBeanFactory lbf, Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        Map beansOfType = lbf.getBeansOfType(type, includePrototypes, includeFactoryBeans);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "Expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfType(ListableBeanFactory lbf, Class type) throws BeansException {
        return BeanFactoryUtils.beanOfType(lbf, type, true, true);
    }
}

