/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.springframework.core.CollectionFactory;

public class CustomCollectionEditor
extends PropertyEditorSupport {
    private final Class collectionType;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$SortedSet;

    public CustomCollectionEditor(Class collectionType) {
        if (collectionType == null) {
            throw new IllegalArgumentException("Collection type is required");
        }
        if (!collectionType.isInterface()) {
            throw new IllegalArgumentException("Collection type has to be an interface");
        }
        if (!(class$java$util$Collection == null ? (class$java$util$Collection = CustomCollectionEditor.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type [" + collectionType.getName() + "] does not implement [java.util.Collection]");
        }
        this.collectionType = collectionType;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (this.collectionType.isInstance(value)) {
            super.setValue(value);
        } else if (value instanceof Collection) {
            Collection source = (Collection)value;
            Collection target = this.createCollection(this.collectionType, source.size());
            target.addAll(source);
            super.setValue(target);
        } else if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            Collection target = this.createCollection(this.collectionType, length);
            for (int i = 0; i < length; ++i) {
                target.add(Array.get(value, i));
            }
            super.setValue(target);
        } else {
            Collection target = this.createCollection(this.collectionType, 1);
            target.add(value);
            super.setValue(target);
        }
    }

    protected Collection createCollection(Class collectionType, int initialCapacity) {
        if ((class$java$util$List == null ? (class$java$util$List = CustomCollectionEditor.class$("java.util.List")) : class$java$util$List).equals(collectionType)) {
            return new ArrayList(initialCapacity);
        }
        if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CustomCollectionEditor.class$("java.util.SortedSet")) : class$java$util$SortedSet).equals(collectionType)) {
            return new TreeSet();
        }
        return CollectionFactory.createLinkedSetIfPossible(initialCapacity);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

