/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.beans.factory.access.DefaultBeanFactoryReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jndi.JndiTemplate;
import org.springframework.util.StringUtils;

public class JndiBeanFactoryLocator
implements BeanFactoryLocator {
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; \t\n";
    protected Log logger = LogFactory.getLog(this.getClass());

    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        String beanFactoryPath = null;
        try {
            beanFactoryPath = (String)new JndiTemplate().lookup(factoryKey);
            this.logger.info((Object)("BeanFactoryPath from JNDI is [" + beanFactoryPath + "]"));
            String[] paths = StringUtils.tokenizeToStringArray(beanFactoryPath, BEAN_FACTORY_PATH_DELIMITERS, true, true);
            return this.createBeanFactory(paths);
        }
        catch (NamingException ex) {
            throw new BootstrapException("Define an environment variable 'ejb/BeanFactoryPath' containing the class path locations of XML bean definition files", ex);
        }
    }

    protected BeanFactoryReference createBeanFactory(String[] resources) throws BeansException {
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(factory);
        for (int i = 0; i < resources.length; ++i) {
            reader.loadBeanDefinitions(new ClassPathResource(resources[i]));
        }
        factory.preInstantiateSingletons();
        return new DefaultBeanFactoryReference(factory);
    }
}

