/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.UrlResource;

public class SingletonBeanFactoryLocator
implements BeanFactoryLocator {
    public static final String BEANS_REFS_XML_NAME = "beanRefFactory.xml";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator = SingletonBeanFactoryLocator.class$("org.springframework.beans.factory.access.SingletonBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator));
    private static Map instances = new HashMap();
    private Map bfgInstancesByKey = new HashMap();
    private Map bfgInstancesByObj = new HashMap();
    private String resourceName;
    static /* synthetic */ Class class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator;

    public static BeanFactoryLocator getInstance() throws FatalBeanException {
        return SingletonBeanFactoryLocator.getInstance(BEANS_REFS_XML_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws FatalBeanException {
        Map map = instances;
        synchronized (map) {
            logger.debug((Object)("SingletonBeanFactoryLocator.getInstance(): SingletonBeanFactoryLocator.class=" + (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator = SingletonBeanFactoryLocator.class$("org.springframework.beans.factory.access.SingletonBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator) + ", hash= " + (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator = SingletonBeanFactoryLocator.class$("org.springframework.beans.factory.access.SingletonBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SingletonBeanFactoryLocator).hashCode()));
            logger.debug((Object)("SingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances));
            BeanFactoryLocator bfl = (BeanFactoryLocator)instances.get(selector);
            if (bfl == null) {
                bfl = new SingletonBeanFactoryLocator(selector);
                instances.put(selector, bfl);
            }
            return bfl;
        }
    }

    protected SingletonBeanFactoryLocator() {
        this.resourceName = BEANS_REFS_XML_NAME;
    }

    protected SingletonBeanFactoryLocator(String resourceName) {
        this.resourceName = resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanFactoryReference useFactory(String factoryKey) throws FatalBeanException {
        Map map = this.bfgInstancesByKey;
        synchronized (map) {
            Object bean;
            BeanFactoryGroup bfg = (BeanFactoryGroup)this.bfgInstancesByKey.get(this.resourceName);
            logger.debug((Object)("bfgInstancesByKey=" + this.bfgInstancesByKey));
            if (bfg != null) {
                logger.debug((Object)("Factory group with resourceName '" + this.resourceName + "' requested. Using existing instance."));
                bfg.refcount++;
            } else {
                Collection resourceUrls;
                logger.debug((Object)("Factory group with resourceName '" + this.resourceName + "' requested. Creating new instance."));
                try {
                    resourceUrls = this.getAllDefinitionResources(this.resourceName);
                }
                catch (IOException e) {
                    throw new FatalBeanException("Unable to load group definition. Group resource name:" + this.resourceName + ", factoryKey:" + factoryKey, e);
                }
                int numResources = resourceUrls.size();
                if (numResources == 0) {
                    throw new FatalBeanException("Unable to find definition for specified definition. Group:" + this.resourceName + ", contextId:" + factoryKey);
                }
                String[] resources = new String[numResources];
                Iterator it = resourceUrls.iterator();
                for (int i = 0; i < numResources; ++i) {
                    URL u = (URL)it.next();
                    resources[i] = u.toExternalForm();
                }
                BeanFactory groupContext = this.createDefinition(resources);
                bfg = new BeanFactoryGroup();
                bfg.definition = groupContext;
                bfg.resourceName = this.resourceName;
                bfg.refcount = 1;
                this.bfgInstancesByKey.put(this.resourceName, bfg);
                this.bfgInstancesByObj.put(groupContext, bfg);
            }
            BeanFactory groupContext = bfg.definition;
            String lookupId = factoryKey;
            try {
                bean = groupContext.getBean(lookupId);
            }
            catch (BeansException e) {
                throw new FatalBeanException("Unable to return specified BeanFactory instance: factoryKey=" + factoryKey + ", from group with resourceName: " + this.resourceName, e);
            }
            if (bean instanceof String) {
                lookupId = (String)bean;
                try {
                    bean = groupContext.getBean(lookupId);
                }
                catch (BeansException e) {
                    throw new FatalBeanException("Unable to return specified BeanFactory instance: lookupId=" + lookupId + ", factoryKey=" + factoryKey + ", from group with resourceName: " + this.resourceName, e);
                }
            }
            if (!(bean instanceof BeanFactory)) {
                throw new FatalBeanException("Returned bean is not BeanFactory or its subclass. lookupId=" + lookupId + ", factoryKey=" + factoryKey + ", from group with resourceName: " + this.resourceName + ". Returned cbject class is: " + bean.getClass());
            }
            final BeanFactory retval = (BeanFactory)bean;
            return new BeanFactoryReference(){

                public BeanFactory getFactory() {
                    return retval;
                }

                public void release() throws FatalBeanException {
                }
            };
        }
    }

    protected BeanFactory createDefinition(String[] resources) throws FatalBeanException {
        DefaultListableBeanFactory fac = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(fac);
        for (int i = 0; i < resources.length; ++i) {
            try {
                reader.loadBeanDefinitions(new UrlResource(resources[i]));
                continue;
            }
            catch (MalformedURLException e) {
                throw new FatalBeanException("Bad URL when loading definition", e);
            }
        }
        fac.preInstantiateSingletons();
        return fac;
    }

    protected Collection getAllDefinitionResources(String resourceName) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = cl.getResources(resourceName);
        ArrayList<URL> l = new ArrayList<URL>();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BeanFactoryGroup {
        private String resourceName;
        private int refcount = 0;
        private BeanFactory definition;

        private BeanFactoryGroup() {
        }
    }
}

