/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.rmi.RmiInvocationHandler;
import org.springframework.remoting.support.RemoteInvocationBasedAccessor;

public class RmiClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
InitializingBean {
    private Remote rmiProxy;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public void afterPropertiesSet() throws IOException, NotBoundException {
        if (this.getServiceUrl() == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        Remote remoteObj = this.createRmiProxy();
        if (remoteObj instanceof RmiInvocationHandler) {
            this.logger.info((Object)("RMI object [" + this.getServiceUrl() + "] is an RMI invoker"));
        } else if (this.getServiceInterface() != null) {
            boolean isImpl = this.getServiceInterface().isInstance(remoteObj);
            this.logger.info((Object)("Using service interface [" + this.getServiceInterface().getName() + "] for RMI object [" + this.getServiceUrl() + "] - " + (!isImpl ? "not " : "") + "directly implemented"));
        }
        this.rmiProxy = remoteObj;
    }

    protected Remote createRmiProxy() throws IOException, NotBoundException {
        return Naming.lookup(this.getServiceUrl());
    }

    protected Remote getRmiProxy() {
        return this.rmiProxy;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            if (this.rmiProxy instanceof RmiInvocationHandler) {
                RmiInvocationHandler invocationHandler = (RmiInvocationHandler)this.rmiProxy;
                return this.invoke(invocation, invocationHandler);
            }
            Method method = invocation.getMethod();
            if (method.getDeclaringClass().isInstance(this.rmiProxy)) {
                return method.invoke((Object)this.rmiProxy, invocation.getArguments());
            }
            Method proxyMethod = this.rmiProxy.getClass().getMethod(method.getName(), method.getParameterTypes());
            return proxyMethod.invoke((Object)this.rmiProxy, invocation.getArguments());
        }
        catch (RemoteException ex) {
            this.logger.debug((Object)("RMI invoker for service [" + this.getServiceUrl() + "] threw exception"), (Throwable)ex);
            if (!Arrays.asList(invocation.getMethod().getExceptionTypes()).contains(class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = RmiClientInterceptor.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
                throw new RemoteAccessException("Cannot access RMI invoker for [" + this.getServiceUrl() + "]", ex);
            }
            throw ex;
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            this.logger.debug((Object)("RMI method of service [" + this.getServiceUrl() + "] threw exception"), targetException);
            if (targetException instanceof RemoteException && !Arrays.asList(invocation.getMethod().getExceptionTypes()).contains(class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = RmiClientInterceptor.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
                throw new RemoteAccessException("Cannot access RMI service [" + this.getServiceUrl() + "]", targetException);
            }
            throw targetException;
        }
        catch (RuntimeException ex) {
            throw new RemoteAccessException("Failed to invoke RMI service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected Object invoke(MethodInvocation methodInvocation, RmiInvocationHandler invocationHandler) throws RemoteException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return invocationHandler.invoke(this.createRemoteInvocation(methodInvocation));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

