/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;

public class MimeMessageHelper {
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_CHARSET_SUFFIX = ";charset=";
    private static final String HEADER_CONTENT_ID = "Content-ID";
    private final MimeMessage mimeMessage;
    private MimeMultipart mimeMultipart;
    private String encoding;

    public MimeMessageHelper(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
    }

    public MimeMessageHelper(MimeMessage mimeMessage, String encoding) {
        this(mimeMessage);
        this.encoding = encoding;
    }

    public MimeMessageHelper(MimeMessage mimeMessage, boolean multipart) throws MessagingException {
        this.mimeMessage = mimeMessage;
        if (multipart) {
            this.mimeMultipart = new MimeMultipart();
            this.mimeMessage.setContent((Multipart)this.mimeMultipart);
        }
    }

    public MimeMessageHelper(MimeMessage mimeMessage, boolean multipart, String encoding) throws MessagingException {
        this(mimeMessage, multipart);
        this.encoding = encoding;
    }

    public final MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public final boolean isMultipart() {
        return this.mimeMultipart != null;
    }

    public final MimeMultipart getMimeMultipart() throws IllegalStateException {
        if (this.mimeMultipart == null) {
            throw new IllegalStateException("Cannot access root multipart object - not in multipart mode");
        }
        return this.mimeMultipart;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFrom(InternetAddress from) throws MessagingException {
        this.mimeMessage.setFrom((Address)from);
    }

    public void setFrom(String from) throws MessagingException {
        this.mimeMessage.setFrom((Address)new InternetAddress(from));
    }

    public void setFrom(String from, String personal) throws MessagingException, UnsupportedEncodingException {
        this.mimeMessage.setFrom((Address)(this.getEncoding() != null ? new InternetAddress(from, personal, this.getEncoding()) : new InternetAddress(from, personal)));
    }

    public void setReplyTo(InternetAddress replyTo) throws MessagingException {
        this.mimeMessage.setReplyTo((Address[])new InternetAddress[]{replyTo});
    }

    public void setReplyTo(String replyTo) throws MessagingException {
        this.mimeMessage.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(replyTo)});
    }

    public void setReplyTo(String replyTo, String personal) throws MessagingException, UnsupportedEncodingException {
        InternetAddress replyToAddress = this.getEncoding() != null ? new InternetAddress(replyTo, personal, this.getEncoding()) : new InternetAddress(replyTo, personal);
        this.mimeMessage.setReplyTo((Address[])new InternetAddress[]{replyToAddress});
    }

    public void setTo(InternetAddress to) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.TO, (Address)to);
    }

    public void setTo(InternetAddress[] to) throws MessagingException {
        this.mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])to);
    }

    public void setTo(String to) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
    }

    public void setTo(String[] to) throws MessagingException {
        InternetAddress[] addresses = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            addresses[i] = new InternetAddress(to[i]);
        }
        this.mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])addresses);
    }

    public void addTo(InternetAddress to) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.TO, (Address)to);
    }

    public void addTo(String to) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
    }

    public void addTo(String to, String personal) throws MessagingException, UnsupportedEncodingException {
        this.mimeMessage.addRecipient(Message.RecipientType.TO, (Address)(this.getEncoding() != null ? new InternetAddress(to, personal, this.getEncoding()) : new InternetAddress(to, personal)));
    }

    public void setCc(InternetAddress cc) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.CC, (Address)cc);
    }

    public void setCc(InternetAddress[] cc) throws MessagingException {
        this.mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])cc);
    }

    public void setCc(String cc) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
    }

    public void setCc(String[] cc) throws MessagingException {
        InternetAddress[] addresses = new InternetAddress[cc.length];
        for (int i = 0; i < cc.length; ++i) {
            addresses[i] = new InternetAddress(cc[i]);
        }
        this.mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])addresses);
    }

    public void addCc(InternetAddress cc) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.CC, (Address)cc);
    }

    public void addCc(String cc) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
    }

    public void addCc(String cc, String personal) throws MessagingException, UnsupportedEncodingException {
        this.mimeMessage.addRecipient(Message.RecipientType.CC, (Address)(this.getEncoding() != null ? new InternetAddress(cc, personal, this.getEncoding()) : new InternetAddress(cc, personal)));
    }

    public void setBcc(InternetAddress bcc) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.BCC, (Address)bcc);
    }

    public void setBcc(InternetAddress[] bcc) throws MessagingException {
        this.mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
    }

    public void setBcc(String bcc) throws MessagingException {
        this.mimeMessage.setRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
    }

    public void setBcc(String[] bcc) throws MessagingException {
        InternetAddress[] addresses = new InternetAddress[bcc.length];
        for (int i = 0; i < bcc.length; ++i) {
            addresses[i] = new InternetAddress(bcc[i]);
        }
        this.mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])addresses);
    }

    public void addBcc(InternetAddress bcc) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)bcc);
    }

    public void addBcc(String bcc) throws MessagingException {
        this.mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
    }

    public void addBcc(String bcc, String personal) throws MessagingException, UnsupportedEncodingException {
        this.mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)(this.getEncoding() != null ? new InternetAddress(bcc, personal, this.getEncoding()) : new InternetAddress(bcc, personal)));
    }

    public void setSentDate(Date sentDate) throws MessagingException {
        this.mimeMessage.setSentDate(sentDate);
    }

    public void setSubject(String subject) throws MessagingException {
        if (this.getEncoding() != null) {
            this.mimeMessage.setSubject(subject, this.getEncoding());
        } else {
            this.mimeMessage.setSubject(subject);
        }
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, false);
    }

    public void setText(String text, boolean html) throws MessagingException {
        Object partToUse = null;
        partToUse = this.mimeMultipart != null ? this.getMainPart() : this.mimeMessage;
        this.setTextToMimePart((MimePart)partToUse, text, html);
    }

    private MimeBodyPart getMainPart() throws MessagingException {
        MimeBodyPart bodyPart = null;
        for (int i = 0; i < this.mimeMultipart.getCount(); ++i) {
            BodyPart bp = this.mimeMultipart.getBodyPart(i);
            if (bp.getFileName() != null) continue;
            bodyPart = (MimeBodyPart)bp;
        }
        if (bodyPart == null) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            this.mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            bodyPart = mimeBodyPart;
        }
        return bodyPart;
    }

    private void setTextToMimePart(MimePart mimePart, String text, boolean html) throws MessagingException {
        if (html) {
            if (this.getEncoding() != null) {
                mimePart.setContent((Object)text, "text/html;charset=" + this.getEncoding());
            } else {
                mimePart.setContent((Object)text, CONTENT_TYPE_HTML);
            }
        } else if (this.getEncoding() != null) {
            mimePart.setText(text, this.getEncoding());
        } else {
            mimePart.setText(text);
        }
    }

    public void addInline(String contentId, DataSource dataSource) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(new DataHandler(dataSource));
        mimeBodyPart.setHeader(HEADER_CONTENT_ID, "<" + contentId + ">");
        mimeBodyPart.setDisposition("inline");
        this.getMimeMultipart().addBodyPart((BodyPart)mimeBodyPart);
    }

    public void addInline(String contentId, File file) throws MessagingException {
        this.addInline(contentId, (DataSource)new FileDataSource(file));
    }

    public void addInline(String contentId, Resource resource) throws MessagingException {
        String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(resource.getFilename());
        this.addInline(contentId, (InputStreamSource)resource, contentType);
    }

    public void addInline(String contentId, InputStreamSource inputStreamSource, String contentType) throws MessagingException {
        DataSource dataSource = MimeMessageHelper.createDataSource(inputStreamSource, contentType, "inline");
        this.addInline(contentId, dataSource);
    }

    public void addAttachment(String attachmentFilename, DataSource dataSource) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setFileName(attachmentFilename);
        mimeBodyPart.setDataHandler(new DataHandler(dataSource));
        this.getMimeMultipart().addBodyPart((BodyPart)mimeBodyPart);
    }

    public void addAttachment(String attachmentFilename, File file) throws MessagingException {
        this.addAttachment(attachmentFilename, (DataSource)new FileDataSource(file));
    }

    public void addAttachment(String attachmentFilename, InputStreamSource inputStreamSource) throws MessagingException {
        String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(attachmentFilename);
        DataSource dataSource = MimeMessageHelper.createDataSource(inputStreamSource, contentType, attachmentFilename);
        this.addAttachment(attachmentFilename, dataSource);
    }

    private static DataSource createDataSource(final InputStreamSource inputStreamSource, final String contentType, final String name) {
        return new DataSource(){

            public InputStream getInputStream() throws IOException {
                return inputStreamSource.getInputStream();
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
            }

            public String getContentType() {
                return contentType;
            }

            public String getName() {
                return name;
            }
        };
    }
}

