/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.rmi.RemoteInvocationWrapper;
import org.springframework.remoting.support.RemoteExporter;

public class RmiServiceExporter
extends RemoteExporter
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String serviceName;
    private int servicePort = 0;
    private int registryPort = 1099;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServicePort(int servicePort) {
        this.servicePort = servicePort;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.serviceName == null) {
            throw new IllegalArgumentException("serviceName is required");
        }
        Registry registry = null;
        this.logger.info((Object)("Looking for RMI registry at port '" + this.registryPort + "'"));
        try {
            registry = LocateRegistry.getRegistry(this.registryPort);
            registry.list();
        }
        catch (RemoteException ex) {
            this.logger.debug((Object)"RMI registry access threw exception", (Throwable)ex);
            this.logger.warn((Object)"Could not detect RMI registry - creating new one");
            registry = LocateRegistry.createRegistry(this.registryPort);
        }
        this.logger.info((Object)("Binding RMI service '" + this.serviceName + "' to registry at port '" + this.registryPort + "'"));
        if (this.getService() instanceof Remote) {
            Remote exportedObject = UnicastRemoteObject.exportObject((Remote)this.getService(), this.servicePort);
            registry.rebind(this.serviceName, exportedObject);
        } else {
            this.logger.info((Object)("RMI object '" + this.serviceName + "' is an RMI invoker"));
            RemoteInvocationWrapper wrapper = new RemoteInvocationWrapper(this.getProxyForService(), this.servicePort);
            registry.rebind(this.serviceName, wrapper);
        }
    }
}

