/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private final Set ignoreDependencyTypes = new HashSet();
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanFactory;

    public AbstractAutowireCapableBeanFactory() {
        this.ignoreDependencyType(class$org$springframework$beans$factory$BeanFactory == null ? (class$org$springframework$beans$factory$BeanFactory = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanFactory")) : class$org$springframework$beans$factory$BeanFactory);
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.setParentBeanFactory(parentBeanFactory);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public void ignoreDependencyType(Class type) {
        this.ignoreDependencyTypes.add(type);
    }

    public Set getIgnoredDependencyTypes() {
        return this.ignoreDependencyTypes;
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd).getWrappedInstance();
        }
        Object bean = this.instantiationStrategy.instantiate(bd, null, this);
        this.populateBean(bean.getClass().getName(), bd, this.createBeanWrapper(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode != 1 && autowireMode != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition bd = new RootBeanDefinition(existingBean.getClass(), autowireMode, dependencyCheck);
        this.populateBean(existingBean.getClass().getName(), bd, this.createBeanWrapper(existingBean));
    }

    public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, true);
        BeanWrapper bw = this.createBeanWrapper(existingBean);
        this.initBeanWrapper(bw);
        this.applyPropertyValues(beanName, bd, bw, bd.getPropertyValues());
    }

    protected Object applyBeanPostProcessorsBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before instantiaion of bean '" + beanName + "'"));
        }
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            Object result;
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (result = ((InstantiationAwareBeanPostProcessor)beanProcessor).postProcessBeforeInstantiation(beanClass, beanName)) == null) continue;
            return result;
        }
        return null;
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors before initialization of bean '" + beanName + "'"));
        }
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, beanName);
            if (result != null) continue;
            throw new BeanCreationException(beanName, "postProcessBeforeInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + beanName + "]");
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking BeanPostProcessors after initialization of bean '" + beanName + "'"));
        }
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, beanName);
            if (result != null) continue;
            throw new BeanCreationException(beanName, "postProcessAfterInitialization method of BeanPostProcessor [" + beanProcessor + "] returned null for bean [" + result + "] with name [" + beanName + "]");
        }
        return result;
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args) throws BeansException {
        return this.createBean(beanName, mergedBeanDefinition, args, true);
    }

    protected Object createBean(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] args, boolean allowEagerCaching) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + beanName + "' with merged definition [" + mergedBeanDefinition + "]"));
        }
        Object bean = null;
        if (mergedBeanDefinition.hasBeanClass() && (bean = this.applyBeanPostProcessorsBeforeInstantiation(mergedBeanDefinition.getBeanClass(), beanName)) != null) {
            return bean;
        }
        if (mergedBeanDefinition.getDependsOn() != null) {
            for (int i = 0; i < mergedBeanDefinition.getDependsOn().length; ++i) {
                this.getBean(mergedBeanDefinition.getDependsOn()[i]);
            }
        }
        BeanWrapper instanceWrapper = null;
        Object originalBean = null;
        String errorMessage = null;
        boolean eagerlyCached = false;
        try {
            errorMessage = "Instantiation of bean failed";
            if (mergedBeanDefinition.getFactoryMethodName() != null) {
                instanceWrapper = this.instantiateUsingFactoryMethod(beanName, mergedBeanDefinition, args);
            } else if (mergedBeanDefinition.getResolvedAutowireMode() == 3 || mergedBeanDefinition.hasConstructorArgumentValues()) {
                instanceWrapper = this.autowireConstructor(beanName, mergedBeanDefinition);
            } else {
                Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, this);
                instanceWrapper = this.createBeanWrapper(beanInstance);
                this.initBeanWrapper(instanceWrapper);
            }
            bean = instanceWrapper.getWrappedInstance();
            if (allowEagerCaching && mergedBeanDefinition.isSingleton()) {
                this.addSingleton(beanName, bean);
                eagerlyCached = true;
            }
            errorMessage = "Initialization of bean failed";
            this.populateBean(beanName, mergedBeanDefinition, instanceWrapper);
            if (bean instanceof BeanNameAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanName on BeanNameAware bean '" + beanName + "'"));
                }
                ((BeanNameAware)bean).setBeanName(beanName);
            }
            if (bean instanceof BeanFactoryAware) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invoking setBeanFactory on BeanFactoryAware bean '" + beanName + "'"));
                }
                ((BeanFactoryAware)bean).setBeanFactory(this);
            }
            originalBean = bean;
            bean = this.applyBeanPostProcessorsBeforeInitialization(bean, beanName);
            this.invokeInitMethods(beanName, bean, mergedBeanDefinition);
            bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
        }
        catch (BeanCreationException ex) {
            if (eagerlyCached) {
                this.removeSingleton(beanName);
            }
            throw ex;
        }
        catch (Throwable ex) {
            if (eagerlyCached) {
                this.removeSingleton(beanName);
            }
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, errorMessage, ex);
        }
        this.registerDisposableBeanIfNecessary(beanName, originalBean, mergedBeanDefinition);
        return bean;
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition, Object[] explicitArgs) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = null;
        int minNrOfArgs = 0;
        if (explicitArgs == null) {
            resolvedValues = new ConstructorArgumentValues();
            minNrOfArgs = this.resolveConstructorArguments(beanName, mergedBeanDefinition, cargs, resolvedValues);
        } else {
            minNrOfArgs = explicitArgs.length;
        }
        boolean isStatic = true;
        Class<?> factoryClass = null;
        Object factoryBean = null;
        if (mergedBeanDefinition.getFactoryBeanName() != null) {
            factoryBean = this.getBean(mergedBeanDefinition.getFactoryBeanName());
            factoryClass = factoryBean.getClass();
            isStatic = false;
        } else {
            factoryClass = mergedBeanDefinition.getBeanClass();
        }
        BeanWrapper bw = this.createBeanWrapper(null);
        this.initBeanWrapper(bw);
        Method[] candidates = factoryClass.getMethods();
        Method factoryMethodToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < candidates.length; ++i) {
            Method factoryMethod = candidates[i];
            if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mergedBeanDefinition.getFactoryMethodName()) || factoryMethod.getParameterTypes().length < minNrOfArgs) continue;
            Class[] argTypes = factoryMethod.getParameterTypes();
            Object[] args = null;
            if (resolvedValues != null) {
                try {
                    args = this.createArgumentArray(beanName, mergedBeanDefinition, resolvedValues, bw, argTypes);
                }
                catch (UnsatisfiedDependencyException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring factory method [" + factoryMethod + "] of bean '" + beanName + "': could not satisfy dependencies"), (Throwable)((Object)ex));
                    }
                    if (i != candidates.length - 1 || factoryMethodToUse != null) continue;
                    throw ex;
                }
            } else {
                if (argTypes.length != explicitArgs.length) continue;
                args = explicitArgs;
            }
            int typeDiffWeight = AutowireUtils.getTypeDifferenceWeight(argTypes, args);
            if (typeDiffWeight >= minTypeDiffWeight) continue;
            factoryMethodToUse = factoryMethod;
            argsToUse = args;
            minTypeDiffWeight = typeDiffWeight;
        }
        if (factoryMethodToUse == null) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Cannot find matching factory method '" + mergedBeanDefinition.getFactoryMethodName() + "' on class [" + factoryClass.getName() + "]");
        }
        Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, this, factoryBean, factoryMethodToUse, argsToUse);
        bw.setWrappedInstance(beanInstance);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bean '" + beanName + "' instantiated via factory method '" + factoryMethodToUse + "'"));
        }
        return bw;
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mergedBeanDefinition) throws BeansException {
        ConstructorArgumentValues cargs = mergedBeanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues resolvedValues = new ConstructorArgumentValues();
        BeanWrapper bw = this.createBeanWrapper(null);
        this.initBeanWrapper(bw);
        int minNrOfArgs = 0;
        if (cargs != null) {
            minNrOfArgs = this.resolveConstructorArguments(beanName, mergedBeanDefinition, cargs, resolvedValues);
        }
        Constructor[] candidates = mergedBeanDefinition.getBeanClass().getDeclaredConstructors();
        AutowireUtils.sortConstructors(candidates);
        Constructor constructorToUse = null;
        Object[] argsToUse = null;
        int minTypeDiffWeight = Integer.MAX_VALUE;
        for (int i = 0; i < candidates.length; ++i) {
            Constructor constructor = candidates[i];
            if (constructorToUse != null && constructorToUse.getParameterTypes().length > constructor.getParameterTypes().length) break;
            if (constructor.getParameterTypes().length < minNrOfArgs) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' (hint: specify index arguments for simple parameters to avoid type ambiguities)");
            }
            try {
                Class[] argTypes = constructor.getParameterTypes();
                Object[] args = this.createArgumentArray(beanName, mergedBeanDefinition, resolvedValues, bw, argTypes);
                int typeDiffWeight = AutowireUtils.getTypeDifferenceWeight(argTypes, args);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                constructorToUse = constructor;
                argsToUse = args;
                minTypeDiffWeight = typeDiffWeight;
                continue;
            }
            catch (UnsatisfiedDependencyException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring constructor [" + constructor + "] of bean '" + beanName + "': " + ex.getMessage()));
                }
                if (i != candidates.length - 1 || constructorToUse != null) continue;
                throw ex;
            }
        }
        if (constructorToUse == null) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Could not resolve matching constructor");
        }
        Object beanInstance = this.instantiationStrategy.instantiate(mergedBeanDefinition, beanName, this, constructorToUse, argsToUse);
        bw.setWrappedInstance(beanInstance);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bean '" + beanName + "' instantiated via constructor [" + constructorToUse + "]"));
        }
        return bw;
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mergedBeanDefinition, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        int minNrOfArgs = cargs.getArgumentCount();
        Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            int index = (Integer)entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            String argName = "constructor argument with index " + index;
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue();
            Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, valueHolder.getValue());
            resolvedValues.addIndexedArgumentValue(index, resolvedValue, valueHolder.getType());
        }
        it = cargs.getGenericArgumentValues().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)((Object)it.next());
            String argName = "constructor argument";
            Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, valueHolder.getValue());
            resolvedValues.addGenericArgumentValue(resolvedValue, valueHolder.getType());
        }
        return minNrOfArgs;
    }

    private Object[] createArgumentArray(String beanName, RootBeanDefinition mergedBeanDefinition, ConstructorArgumentValues resolvedValues, BeanWrapper bw, Class[] argTypes) throws UnsatisfiedDependencyException {
        Object[] args = new Object[argTypes.length];
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(argTypes.length);
        for (int j = 0; j < argTypes.length; ++j) {
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(j, argTypes[j]);
            if (valueHolder != null && !usedValueHolders.contains(valueHolder)) {
                usedValueHolders.add(valueHolder);
                try {
                    args[j] = this.doTypeConversionIfNecessary(valueHolder.getValue(), argTypes[j], bw);
                    continue;
                }
                catch (TypeMismatchException ex) {
                    throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, j, argTypes[j], "Could not convert constructor argument value [" + valueHolder.getValue() + "] to required type [" + argTypes[j].getName() + "]: " + ex.getMessage());
                }
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() != 3) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, j, argTypes[j], "Ambiguous constructor argument types - did you specify the correct bean references as generic constructor arguments?");
            }
            Map matchingBeans = this.findMatchingBeans(argTypes[j]);
            if (matchingBeans == null || matchingBeans.size() != 1) {
                int matchingBeansCount = matchingBeans != null ? matchingBeans.size() : 0;
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, j, argTypes[j], "There are " + matchingBeansCount + " beans of type [" + argTypes[j] + "] for autowiring constructor. There should have been 1 to be able to " + "autowire constructor of bean '" + beanName + "'.");
            }
            String autowiredBeanName = (String)matchingBeans.keySet().iterator().next();
            Object autowiredBean = matchingBeans.values().iterator().next();
            args[j] = autowiredBean;
            if (mergedBeanDefinition.isSingleton()) {
                this.registerDependentBean(autowiredBeanName, beanName);
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via constructor to bean named '" + autowiredBeanName + "'"));
        }
        return args;
    }

    protected void populateBean(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) throws BeansException {
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        if (mergedBeanDefinition.getResolvedAutowireMode() == 1 || mergedBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mpvs = new MutablePropertyValues(pvs);
            if (mergedBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mergedBeanDefinition, bw, mpvs);
            }
            if (mergedBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mergedBeanDefinition, bw, mpvs);
            }
            pvs = mpvs;
        }
        this.dependencyCheck(beanName, mergedBeanDefinition, bw, pvs);
        this.applyPropertyValues(beanName, mergedBeanDefinition, bw, pvs);
    }

    protected void autowireByName(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) throws BeansException {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                if (mergedBeanDefinition.isSingleton()) {
                    this.registerDependentBean(propertyName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, MutablePropertyValues pvs) throws BeansException {
        String[] propertyNames = this.unsatisfiedObjectProperties(mergedBeanDefinition, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Class<?> requiredType = bw.getPropertyDescriptor(propertyName).getPropertyType();
            Map matchingBeans = this.findMatchingBeans(requiredType);
            if (matchingBeans != null && matchingBeans.size() == 1) {
                String autowiredBeanName = (String)matchingBeans.keySet().iterator().next();
                Object autowiredBean = matchingBeans.values().iterator().next();
                pvs.addPropertyValue(propertyName, autowiredBean);
                if (mergedBeanDefinition.isSingleton()) {
                    this.registerDependentBean(autowiredBeanName, beanName);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + autowiredBeanName + "'"));
                continue;
            }
            if (matchingBeans != null && matchingBeans.size() > 1) {
                throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, propertyName, "There are " + matchingBeans.size() + " beans of type [" + requiredType + "] for autowire by type. There should have been 1 to be able to autowire property '" + propertyName + "' of bean '" + beanName + "'.");
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by type: no matching bean found"));
        }
    }

    protected String[] unsatisfiedObjectProperties(RootBeanDefinition mergedBeanDefinition, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        MutablePropertyValues pvs = mergedBeanDefinition.getPropertyValues();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].getWriteMethod() == null || ignoreTypes.contains(pds[i].getPropertyType()) || pvs.contains(pds[i].getName()) || BeanUtils.isSimpleProperty(pds[i].getPropertyType())) continue;
            result.add(pds[i].getName());
        }
        return result.toArray(new String[result.size()]);
    }

    protected void dependencyCheck(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mergedBeanDefinition.getDependencyCheck();
        if (dependencyCheck == 0) {
            return;
        }
        Set ignoreTypes = this.getIgnoredDependencyTypes();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || ignoreTypes.contains(pds[i].getPropertyType()) || pvs.contains(pds[i].getName())) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(mergedBeanDefinition.getResourceDescription(), beanName, pds[i].getName(), "set this property value or disable dependency checking for this bean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPropertyValues(String beanName, RootBeanDefinition mergedBeanDefinition, BeanWrapper bw, PropertyValues pvs) throws BeansException {
        block8: {
            if (pvs == null) {
                return;
            }
            MutablePropertyValues deepCopy = new MutablePropertyValues();
            PropertyValue[] pvArray = pvs.getPropertyValues();
            for (int i = 0; i < pvArray.length; ++i) {
                PropertyValue pv = pvArray[i];
                Object resolvedValue = this.resolveValueIfNecessary(beanName, mergedBeanDefinition, pv.getName(), pv.getValue());
                deepCopy.addPropertyValue(pvArray[i].getName(), resolvedValue);
            }
            try {
                if (!this.getCustomEditors().isEmpty()) {
                    AbstractAutowireCapableBeanFactory i = this;
                    synchronized (i) {
                        bw.setPropertyValues(deepCopy);
                        break block8;
                    }
                }
                bw.setPropertyValues(deepCopy);
            }
            catch (BeansException ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Error setting property values", (Throwable)((Object)ex));
            }
        }
    }

    protected Object resolveValueIfNecessary(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Object value) throws BeansException {
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
            return this.resolveInnerBeanDefinition(beanName, bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value;
            return this.resolveInnerBeanDefinition(beanName, "(inner bean)", bd);
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            return this.resolveReference(beanName, mergedBeanDefinition, argName, ref);
        }
        if (value instanceof ManagedList) {
            return this.resolveManagedList(beanName, mergedBeanDefinition, argName, (List)value);
        }
        if (value instanceof ManagedSet) {
            return this.resolveManagedSet(beanName, mergedBeanDefinition, argName, (Set)value);
        }
        if (value instanceof ManagedMap) {
            return this.resolveManagedMap(beanName, mergedBeanDefinition, argName, (Map)value);
        }
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            BeanWrapper bw = this.createBeanWrapper(null);
            this.initBeanWrapper(bw);
            try {
                return this.doTypeConversionIfNecessary(typedStringValue.getValue(), typedStringValue.getTargetType(), bw);
            }
            catch (BeansException ex) {
                throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Error converting typed String value for " + argName, (Throwable)((Object)ex));
            }
        }
        return value;
    }

    private Object resolveInnerBeanDefinition(String beanName, String innerBeanName, BeanDefinition innerBd) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving inner bean definition '" + innerBeanName + "' of bean '" + beanName + "'"));
        }
        RootBeanDefinition mergedInnerBd = this.getMergedBeanDefinition(innerBeanName, innerBd);
        Object innerBean = this.createBean(innerBeanName, mergedInnerBd, null, false);
        if (mergedInnerBd.isSingleton()) {
            this.registerDependentBean(innerBeanName, beanName);
        }
        return this.getObjectForSharedInstance(innerBeanName, innerBean);
    }

    private Object resolveReference(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, RuntimeBeanReference ref) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving reference from property '" + argName + "' in bean '" + beanName + "' to bean '" + ref.getBeanName() + "'"));
        }
        try {
            if (ref.isToParent()) {
                if (this.getParentBeanFactory() == null) {
                    throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' in parent factory: no parent factory available");
                }
                return this.getParentBeanFactory().getBean(ref.getBeanName());
            }
            if (mergedBeanDefinition.isSingleton()) {
                this.registerDependentBean(ref.getBeanName(), beanName);
            }
            return this.getBean(ref.getBeanName());
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mergedBeanDefinition.getResourceDescription(), beanName, "Can't resolve reference to bean '" + ref.getBeanName() + "' while setting property '" + argName + "'", (Throwable)((Object)ex));
        }
    }

    private List resolveManagedList(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, List ml) throws BeansException {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + i + "]", ml.get(i)));
        }
        return resolved;
    }

    private Set resolveManagedSet(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Set ms) throws BeansException {
        Set resolved = CollectionFactory.createLinkedSetIfPossible((int)ms.size());
        int i = 0;
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            resolved.add(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + i + "]", it.next()));
            ++i;
        }
        return resolved;
    }

    private Map resolveManagedMap(String beanName, RootBeanDefinition mergedBeanDefinition, String argName, Map mm) throws BeansException {
        Map resolved = CollectionFactory.createLinkedMapIfPossible((int)mm.size());
        Iterator it = mm.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            resolved.put(this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName, entry.getKey()), this.resolveValueIfNecessary(beanName, mergedBeanDefinition, argName + "[" + entry.getKey() + "]", entry.getValue()));
        }
        return resolved;
    }

    protected void invokeInitMethods(String beanName, Object bean, RootBeanDefinition mergedBeanDefinition) throws Throwable {
        if (bean instanceof InitializingBean) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking afterPropertiesSet() on bean with name '" + beanName + "'"));
            }
            ((InitializingBean)bean).afterPropertiesSet();
        }
        if (mergedBeanDefinition != null && mergedBeanDefinition.getInitMethodName() != null) {
            this.invokeCustomInitMethod(beanName, bean, mergedBeanDefinition.getInitMethodName());
        }
    }

    protected void invokeCustomInitMethod(String beanName, Object bean, String initMethodName) throws Throwable {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking custom init method '" + initMethodName + "' on bean with name '" + beanName + "'"));
        }
        try {
            Method initMethod = BeanUtils.findMethod(bean.getClass(), initMethodName, null);
            if (initMethod == null) {
                throw new NoSuchMethodException("Couldn't find an init method named '" + initMethodName + "' on bean with name '" + beanName + "'");
            }
            if (!Modifier.isPublic(initMethod.getModifiers())) {
                initMethod.setAccessible(true);
            }
            initMethod.invoke(bean, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected abstract Map findMatchingBeans(Class var1) throws BeansException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

