/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new ArrayList();
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.beanDefinitionNames.toArray(new String[this.beanDefinitionNames.size()]);
    }

    public String[] getBeanDefinitionNames(Class type) {
        ArrayList<String> matches = new ArrayList<String>();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            if (!this.isBeanDefinitionTypeMatch(beanName, type)) continue;
            matches.add(beanName);
        }
        return matches.toArray(new String[matches.size()]);
    }

    public String[] getBeanNamesForType(Class type) {
        List beanNames = this.doGetBeanNamesForType(type, true, true);
        return beanNames.toArray(new String[beanNames.size()]);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        List beanNames = this.doGetBeanNamesForType(type, includePrototypes, includeFactoryBeans);
        Map result = CollectionFactory.createLinkedMapIfPossible((int)beanNames.size());
        Iterator it = beanNames.iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            try {
                result.put(beanName, this.getBean(beanName));
            }
            catch (BeanCreationException ex) {
                if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.BeanCurrentlyInCreationException") : class$org$springframework$beans$factory$BeanCurrentlyInCreationException)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring match to currently created bean '" + beanName + "'"), (Throwable)((Object)ex));
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    protected List doGetBeanNamesForType(Class type, boolean includePrototypes, boolean includeFactoryBeans) {
        boolean isFactoryType = type != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(type);
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            RootBeanDefinition rbd = this.getMergedBeanDefinition(beanName, false);
            if (rbd.isAbstract() || !rbd.hasBeanClass()) continue;
            if ((class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(rbd.getBeanClass()) && !isFactoryType) {
                if (!includeFactoryBeans || !includePrototypes && !this.isSingleton(beanName) || !this.isBeanTypeMatch(beanName, type)) continue;
                result.add(beanName);
                continue;
            }
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            if (!includePrototypes && !rbd.isSingleton() || type != null && !type.isAssignableFrom(rbd.getBeanClass())) continue;
            result.add(beanName);
        }
        String[] singletonNames = this.getSingletonNames();
        for (int i = 0; i < singletonNames.length; ++i) {
            String beanName = singletonNames[i];
            if (this.containsBeanDefinition(beanName)) continue;
            if (this.isFactoryBean(beanName) && !isFactoryType) {
                if (!includeFactoryBeans || !includePrototypes && !this.isSingleton(beanName) || !this.isBeanTypeMatch(beanName, type)) continue;
                result.add(beanName);
                continue;
            }
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            if (!this.isBeanTypeMatch(beanName, type)) continue;
            result.add(beanName);
        }
        return result;
    }

    private boolean isBeanTypeMatch(String beanName, Class type) {
        if (type == null) {
            return true;
        }
        Class beanType = this.getType(beanName);
        return beanType != null && type.isAssignableFrom(beanType);
    }

    private boolean isBeanDefinitionTypeMatch(String beanName, Class type) {
        if (type == null) {
            return true;
        }
        RootBeanDefinition rbd = this.getMergedBeanDefinition(beanName, false);
        return rbd.hasBeanClass() && type.isAssignableFrom(rbd.getBeanClass());
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in factory [" + this + "]"));
        }
        try {
            Iterator it = this.beanDefinitionNames.iterator();
            while (it.hasNext()) {
                RootBeanDefinition bd;
                String beanName = (String)it.next();
                if (!this.containsBeanDefinition(beanName) || !(bd = this.getMergedBeanDefinition(beanName, false)).hasBeanClass() || bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
                if ((class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(bd.getBeanClass())) {
                    FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                    if (!factory.isSingleton()) continue;
                    this.getBean(beanName);
                    continue;
                }
                this.getBean(beanName);
            }
        }
        catch (BeansException ex) {
            try {
                this.destroySingletons();
            }
            catch (Throwable ex2) {
                this.logger.error((Object)"Pre-instantiating singletons failed, and couldn't destroy already created singletons", ex2);
            }
            throw ex;
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object oldBeanDefinition;
        Assert.hasText((String)beanName, (String)"Bean name must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"Bean definition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition with name failed", (Throwable)((Object)ex));
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(beanName)) != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': there's already [" + oldBeanDefinition + "] bound");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
            }
        } else {
            this.beanDefinitionNames.add(beanName);
        }
        this.beanDefinitionMap.put(beanName, beanDefinition);
        this.removeSingleton(beanName);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            throw new NoSuchBeanDefinitionException(beanName, this.toString());
        }
        return bd;
    }

    protected Map findMatchingBeans(Class requiredType) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this, requiredType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" defining beans [");
        sb.append(StringUtils.arrayToDelimitedString((Object[])this.getBeanDefinitionNames(), (String)","));
        sb.append("]; ");
        if (this.getParentBeanFactory() == null) {
            sb.append("root of BeanFactory hierarchy");
        } else {
            sb.append("parent: " + this.getParentBeanFactory());
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

