/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;

public class RegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements ClassFilter {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String[] patterns = new String[0];
    private Pattern[] compiledPatterns = new Pattern[0];
    private PatternMatcher matcher;

    public void setPattern(String pattern) throws MalformedPatternException {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) throws MalformedPatternException {
        this.patterns = patterns;
        this.compiledPatterns = new Pattern[patterns.length];
        Perl5Compiler compiler = new Perl5Compiler();
        for (int i = 0; i < patterns.length; ++i) {
            this.compiledPatterns[i] = compiler.compile(patterns[i], 32768);
        }
        this.matcher = new Perl5Matcher();
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public boolean matches(Method m, Class targetClass) {
        String patt = m.getDeclaringClass().getName() + "." + m.getName();
        for (int i = 0; i < this.compiledPatterns.length; ++i) {
            boolean matched = this.matcher.matches(patt, this.compiledPatterns[i]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Candidate is: '" + patt + "'; pattern is " + this.compiledPatterns[i].getPattern() + "; matched=" + matched));
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public ClassFilter getClassFilter() {
        return this;
    }
}

