/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util.pipe;

import de.speexx.util.Queue;
import de.speexx.util.pipe.AsyncEvent;
import de.speexx.util.pipe.AsynchronReceivable;
import de.speexx.util.pipe.DispatchObject;
import de.speexx.util.pipe.Filter;
import de.speexx.util.pipe.Processor;
import de.speexx.util.pipe.Receiver;
import de.speexx.util.pipe.SimpleReceiver;

public class BufferedReceiver
extends SimpleReceiver
implements AsynchronReceivable {
    private boolean isOpen = true;
    protected boolean isClosed = false;
    private static final ThreadGroup workLoops = new ThreadGroup("Receiver");
    private final WorkLoop workLoop;
    private final Queue dispatcherQueue = new Queue();
    private final Object finalizeGuardian = new Object(){

        protected void finalize() throws Throwable {
            BufferedReceiver.this.close();
            BufferedReceiver.super.finalize();
        }
    };

    public BufferedReceiver(Filter filter, Processor processor) {
        this(filter, processor, null);
    }

    public BufferedReceiver(Filter filter, Processor processor, String name) {
        super(filter, processor, name);
        this.workLoop = new WorkLoop(this);
        new Thread(workLoops, this.workLoop, this.getName()).start();
    }

    public boolean filterDispatchObject(DispatchObject dispatchObject) {
        return this.workLoop.addDispatchObject(dispatchObject);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() {
        this.workLoop.close();
    }

    private static final class Terminator {
        public static final Terminator INSTANCE = new Terminator();

        private Terminator() {
        }
    }

    private final class WorkLoop
    implements Runnable {
        private final Receiver father;

        public WorkLoop(Receiver father) {
            this.father = father;
        }

        public synchronized boolean addDispatchObject(DispatchObject dispatchObject) {
            if (!BufferedReceiver.this.isClosed) {
                try {
                    if (BufferedReceiver.this.filter.filter(dispatchObject.getFilterObject())) {
                        BufferedReceiver.this.dispatcherQueue.enqueue(dispatchObject);
                        this.notify();
                        return true;
                    }
                }
                catch (Throwable t) {
                    AsyncEvent event = new AsyncEvent(dispatchObject, this.father, (Object)t);
                    BufferedReceiver.this.fireAsyncExceptionEvent(event);
                }
            }
            throw new IllegalStateException(this.getClass().getName() + " '" + BufferedReceiver.this.getName() + "' is closed");
        }

        public synchronized void close() {
            if (BufferedReceiver.this.isOpen && !BufferedReceiver.this.isClosed) {
                BufferedReceiver.this.isClosed = true;
                BufferedReceiver.this.dispatcherQueue.enqueue(Terminator.INSTANCE);
                try {
                    this.notify();
                    while (!BufferedReceiver.this.dispatcherQueue.isEmpty()) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void workLoop() {
            Object o = null;
            WorkLoop workLoop = this;
            synchronized (workLoop) {
                try {
                    while (BufferedReceiver.this.dispatcherQueue.size() == 0) {
                        this.wait();
                    }
                    o = BufferedReceiver.this.dispatcherQueue.dequeue();
                    if (o == Terminator.INSTANCE) {
                        BufferedReceiver.this.isOpen = false;
                        this.notify();
                        return;
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            BufferedReceiver.this.processDispatchObject((DispatchObject)o);
        }

        public void run() {
            BufferedReceiver.this.isOpen = true;
            while (BufferedReceiver.this.isOpen) {
                this.workLoop();
            }
        }
    }
}

