/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.util;

import de.speexx.core.Null;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public final class ParameterList
implements Cloneable,
Serializable {
    static final long serialVersionUID = 2162641384842720178L;
    private static final Class NULL_TYPE = class$de$speexx$core$Null == null ? (class$de$speexx$core$Null = ParameterList.class$("de.speexx.core.Null")) : class$de$speexx$core$Null;
    private final ArrayList objects;
    private final ArrayList clazzes;
    static /* synthetic */ Class class$de$speexx$core$Null;

    public ParameterList() {
        this(2);
    }

    public ParameterList(int size) {
        this.objects = new ArrayList(size);
        this.clazzes = new ArrayList(size);
    }

    public final void add(boolean b) {
        if (b) {
            this.objects.add(Boolean.TRUE);
        } else {
            this.objects.add(Boolean.FALSE);
        }
        this.clazzes.add(Boolean.TYPE);
    }

    public final void add(byte b) {
        this.objects.add(new Byte(b));
        this.clazzes.add(Byte.TYPE);
    }

    public final void add(char c) {
        this.objects.add(new Character(c));
        this.clazzes.add(Character.TYPE);
    }

    public final void add(short s) {
        this.objects.add(new Short(s));
        this.clazzes.add(Short.TYPE);
    }

    public final void add(int i) {
        this.objects.add(new Integer(i));
        this.clazzes.add(Integer.TYPE);
    }

    public final void add(long l) {
        this.objects.add(new Long(l));
        this.clazzes.add(Long.TYPE);
    }

    public final void add(float f) {
        this.objects.add(new Float(f));
        this.clazzes.add(Float.TYPE);
    }

    public final void add(double d) {
        this.objects.add(new Double(d));
        this.clazzes.add(Double.TYPE);
    }

    public final void add(Object o) {
        if (o != null) {
            this.objects.add(o);
            this.clazzes.add(o.getClass());
        } else {
            this.objects.add(Null.INSTANCE);
            this.clazzes.add(NULL_TYPE);
        }
    }

    public final Object[] getObjectList() {
        Object[] tmpArray = this.objects.toArray();
        Object[] objectArray = new Object[tmpArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = tmpArray[i] != Null.INSTANCE ? tmpArray[i] : null;
        }
        return objectArray;
    }

    public final Class[] getClassList() {
        Object[] objectsArray = this.clazzes.toArray();
        Class[] clazzesArray = new Class[objectsArray.length];
        for (int i = 0; i < clazzesArray.length; ++i) {
            clazzesArray[i] = objectsArray[i] != NULL_TYPE ? (Class)objectsArray[i] : null;
        }
        return clazzesArray;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.clazzes.size() * 16 + 16);
        sb.append("[Parameter: ");
        Iterator i = this.clazzes.iterator();
        while (i.hasNext()) {
            Class clazzes = (Class)i.next();
            if (clazzes != NULL_TYPE) {
                sb.append(clazzes.getName());
            } else {
                sb.append("null");
            }
            sb.append(", ");
        }
        return sb.substring(0, sb.length() - 2) + "]";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ParameterList pl = (ParameterList)other;
        return this.objects.equals(pl.objects) && this.clazzes.equals(pl.clazzes);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.objects.hashCode();
        hash = 37 * hash + this.clazzes.hashCode();
        return hash;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

