/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.thread;

import de.speexx.thread.Sync;

public class Semaphore
implements Sync {
    protected int permits;
    private int cursor;

    public Semaphore(int initialPermits) {
        if (initialPermits < 1) {
            throw new IllegalArgumentException("illegal value: " + initialPermits);
        }
        this.permits = initialPermits;
        this.cursor = initialPermits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.cursor <= 0) {
                    this.wait();
                }
                --this.cursor;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.cursor < this.permits) {
                ++this.cursor;
            }
            this.notifyAll();
        }
    }

    public boolean attempt(long millis) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.cursor > 0) {
                --this.cursor;
                return true;
            }
            if (millis <= 0L) {
                return false;
            }
            try {
                long startTime = System.currentTimeMillis();
                long waitTime = millis;
                do {
                    this.wait(waitTime);
                    if (this.cursor <= 0) continue;
                    --this.cursor;
                    return true;
                } while ((waitTime = millis - (System.currentTimeMillis() - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public int getResource() {
        return this.permits;
    }

    public int getFreeResource() {
        return this.cursor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("resources=");
        sb.append(this.getResource());
        sb.append(", freeResources=");
        sb.append(this.getFreeResource());
        return sb.toString();
    }
}

