/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.thread;

import de.speexx.thread.TimeoutException;

public class ReadWriteLock {
    protected int activeReadLocks = 0;
    protected int waitingReadLocks = 0;
    protected int activeWriteLocks = 0;
    protected int waitingWriteLocks = 0;

    protected boolean allowReadLock() {
        return this.activeWriteLocks == 0 && this.waitingWriteLocks == 0;
    }

    protected boolean allowWriteLock() {
        return this.activeReadLocks == 0 && this.activeWriteLocks == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readLock() throws InterruptedException {
        ++this.waitingReadLocks;
        try {
            while (!this.allowReadLock()) {
                this.wait();
            }
            ++this.activeReadLocks;
        }
        finally {
            --this.waitingReadLocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readLock(long timeout) throws InterruptedException, TimeoutException {
        ++this.waitingReadLocks;
        long waitTill = System.currentTimeMillis() + timeout;
        try {
            while (!this.allowReadLock()) {
                this.wait(timeout);
                if (this.allowReadLock() || (timeout = waitTill - System.currentTimeMillis()) >= 0L) continue;
                throw new TimeoutException();
            }
            ++this.activeReadLocks;
        }
        finally {
            --this.waitingReadLocks;
        }
    }

    public synchronized void readUnlock() {
        --this.activeReadLocks;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLock() throws InterruptedException {
        ++this.waitingWriteLocks;
        try {
            while (!this.allowWriteLock()) {
                this.wait();
            }
            ++this.activeWriteLocks;
        }
        finally {
            --this.waitingWriteLocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLock(long timeout) throws InterruptedException, TimeoutException {
        ++this.waitingWriteLocks;
        long waitTill = System.currentTimeMillis() + timeout;
        try {
            while (!this.allowWriteLock()) {
                this.wait(timeout);
                if (this.allowWriteLock() || (timeout = waitTill - System.currentTimeMillis()) >= 0L) continue;
                throw new TimeoutException();
            }
            ++this.activeWriteLocks;
        }
        finally {
            --this.waitingWriteLocks;
        }
    }

    public synchronized void writeUnlock() {
        --this.activeWriteLocks;
        this.notify();
    }
}

