/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.reflect;

import de.speexx.reflect.ProxyFactory;
import de.speexx.reflect.ProxyableInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

class DefaultProxyFactory
extends ProxyFactory {
    private static final String CLASSNAME = "de.speexx.reflect.DefaultProxyFactory";
    private static final Class PROXYABLE_INVOCATION_HANDLER = class$de$speexx$reflect$ProxyableInvocationHandler == null ? (class$de$speexx$reflect$ProxyableInvocationHandler = DefaultProxyFactory.class$("de.speexx.reflect.ProxyableInvocationHandler")) : class$de$speexx$reflect$ProxyableInvocationHandler;
    static /* synthetic */ Class class$de$speexx$reflect$ProxyableInvocationHandler;

    DefaultProxyFactory() {
    }

    public final Object createProxy(Object object) {
        if (object == null) {
            return null;
        }
        String doProxyValue = System.getProperty("de.speexx.proxy");
        if (doProxyValue == null) {
            return object;
        }
        boolean doProxy = "true".equals(doProxyValue.toLowerCase());
        if (!doProxy) {
            return object;
        }
        String handler = System.getProperty("de.speexx.proxy.default");
        if (handler == null) {
            return object;
        }
        StringTokenizer st = new StringTokenizer(handler, " \t");
        HashSet<Object> handlerNames = new HashSet<Object>();
        int tokens = st.countTokens();
        Class[] handlerClazzes = new Class[tokens];
        for (int i = 0; i < tokens; ++i) {
            Object o = st.nextElement();
            if (handlerNames.contains(o)) continue;
            try {
                Class<?> proxyClazz = Class.forName((String)o);
                boolean assignable = PROXYABLE_INVOCATION_HANDLER.isAssignableFrom(proxyClazz);
                if (!assignable) continue;
                handlerNames.add(o);
                handlerClazzes[handlerNames.size() - 1] = proxyClazz;
                continue;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        int clazzes = handlerNames.size();
        ProxyableInvocationHandler[] proxyHandler = new ProxyableInvocationHandler[clazzes];
        try {
            for (int i = 0; i < clazzes; ++i) {
                proxyHandler[i] = (ProxyableInvocationHandler)handlerClazzes[i].newInstance();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex.getMessage());
        }
        return this.createProxy(object, proxyHandler);
    }

    public final Object createProxy(Object target, ProxyableInvocationHandler handler) {
        return this.createProxy(target, new ProxyableInvocationHandler[]{handler});
    }

    public final Object createProxy(Object target, ProxyableInvocationHandler[] handler) {
        if (target == null) {
            return null;
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler array is null");
        }
        for (int i = 0; i < handler.length; ++i) {
            if (handler[i] != null) continue;
            throw new IllegalArgumentException("index " + i + " in" + "handlerarray ist null");
        }
        if (target instanceof InvocationHandler || handler.length == 0) {
            return target;
        }
        Class<?> targetClazz = target.getClass();
        ClassLoader targetClazzLoader = targetClazz.getClassLoader();
        Class[] interfaces = DefaultProxyFactory.getInterfaces(targetClazz);
        handler[handler.length - 1].setInvocationTarget(target);
        Object retval = Proxy.newProxyInstance(targetClazzLoader, interfaces, (InvocationHandler)handler[handler.length - 1]);
        for (int i = handler.length - 2; i >= 0; --i) {
            handler[i].setInvocationTarget(retval);
            retval = Proxy.newProxyInstance(targetClazzLoader, interfaces, (InvocationHandler)handler[i]);
        }
        return retval;
    }

    private static Class[] getInterfaces(Class clazz) {
        Set clazzes = DefaultProxyFactory.getAllClasses(clazz);
        HashSet interfaces = new HashSet();
        Iterator i = clazzes.iterator();
        while (i.hasNext()) {
            Class tmpClass = (Class)i.next();
            Class<?>[] classInterfaces = tmpClass.getInterfaces();
            for (int j = 0; j < classInterfaces.length; ++j) {
                interfaces.add(classInterfaces[j]);
            }
        }
        Class[] clazzArray = new Class[interfaces.size()];
        Iterator iterator = interfaces.iterator();
        for (int i2 = 0; i2 < clazzArray.length; ++i2) {
            clazzArray[i2] = (Class)iterator.next();
        }
        return clazzArray;
    }

    private static Set getAllClasses(Class clazz) {
        HashSet clazzes = new HashSet();
        for (Class tmpClazz = clazz; tmpClazz != null; tmpClazz = tmpClazz.getSuperclass()) {
            clazzes.add(tmpClazz);
        }
        return clazzes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

