/*
 * Decompiled with CFR 0.152.
 */
package de.speexx.reflect;

import de.speexx.reflect.AbstractGenericFactory;
import de.speexx.reflect.DynamicException;
import de.speexx.reflect.ProxyFactory;
import de.speexx.util.Invoker;
import de.speexx.util.ParameterList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class AbstractInvoker
implements Invoker {
    private static final Invoker INVOKER = (Invoker)ProxyFactory.getInstance().createProxy(new AbstractInvoker(){});
    private static final boolean ACCESS = System.getProperty("de.speexx.util.access") != null;
    private static final ParameterList EMPTY_LIST = new ParameterList();

    public static final Invoker getInstance() {
        return INVOKER;
    }

    public final Object invokeMethod(Object instance, String methodName) throws DynamicException {
        return this.invokeMethod(instance, methodName, EMPTY_LIST);
    }

    public final Object invokeMethod(Class clazz, String methodName) throws DynamicException {
        return this.invokeMethod(clazz, methodName, EMPTY_LIST);
    }

    public final Object invokeMethod(Object instance, String methodName, ParameterList arguments) throws DynamicException {
        try {
            Class[] types = arguments.getClassList();
            Class<?> instanceClazz = instance.getClass();
            Method method = null;
            try {
                method = AbstractInvoker.getMethodByFastStrategie(instanceClazz, methodName, types, false);
            }
            catch (NoSuchMethodException ex) {
                method = AbstractInvoker.getMethodBySlowStrategie(instanceClazz, methodName, types, false);
            }
            if (ACCESS) {
                method.setAccessible(true);
            }
            Object[] values = arguments.getObjectList();
            return method.invoke(instance, values);
        }
        catch (Throwable t) {
            throw new DynamicException(t, t.getMessage());
        }
    }

    public final Object invokeMethod(Class clazz, String methodName, ParameterList arguments) throws DynamicException {
        try {
            Class[] types = arguments.getClassList();
            Method method = null;
            try {
                method = AbstractInvoker.getMethodByFastStrategie(clazz, methodName, types, true);
            }
            catch (NoSuchMethodException ex) {
                method = AbstractInvoker.getMethodBySlowStrategie(clazz, methodName, types, true);
            }
            if (ACCESS) {
                method.setAccessible(true);
            }
            Object[] values = arguments.getObjectList();
            return method.invoke(null, values);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DynamicException(t, t.getMessage());
        }
    }

    public final Object getValue(Object instance, String fieldName) throws DynamicException {
        try {
            Field field = AbstractInvoker.getField(instance.getClass(), fieldName, false);
            if (ACCESS) {
                field.setAccessible(true);
            }
            return field.get(instance);
        }
        catch (Throwable t) {
            throw new DynamicException(t, t.getMessage());
        }
    }

    public final Object getValue(Class clazz, String fieldName) throws DynamicException {
        try {
            Field field = AbstractInvoker.getField(clazz, fieldName, true);
            if (ACCESS) {
                field.setAccessible(true);
            }
            return field.get(null);
        }
        catch (Throwable t) {
            throw new DynamicException(t, t.getMessage());
        }
    }

    public final void setValue(Object instance, String fieldName, Object value) throws DynamicException {
        try {
            Field field = AbstractInvoker.getField(instance.getClass(), fieldName, false);
            if (ACCESS) {
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (Throwable t) {
            throw new DynamicException(t, t.getMessage());
        }
    }

    public final void setValue(Class clazz, String fieldName, Object value) throws DynamicException {
        try {
            Field field = AbstractInvoker.getField(clazz, fieldName, true);
            if (ACCESS) {
                field.setAccessible(true);
            }
            field.set(null, value);
        }
        catch (Throwable t) {
            throw new DynamicException(t, t.getMessage());
        }
    }

    private static Method getMethodByFastStrategie(Class clazz, String methodName, Class[] clazzTypes, boolean forStatic) throws NoSuchMethodException {
        if (clazz == null) {
            throw new NoSuchMethodException("Invalid method : " + methodName);
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, clazzTypes);
            int modifiers = method.getModifiers();
            if (forStatic && Modifier.isStatic(modifiers) || !forStatic && !Modifier.isStatic(modifiers)) {
                return method;
            }
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        return AbstractInvoker.getMethodByFastStrategie(clazz.getSuperclass(), methodName, clazzTypes, forStatic);
    }

    private static Method getMethodBySlowStrategie(Class clazz, String methodName, Class[] clazzTypes, boolean forStatic) throws NoSuchMethodException {
        if (clazz == null) {
            throw new NoSuchMethodException("Invalid method : " + methodName);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class[] parameterClazzes = methods[i].getParameterTypes();
            if (parameterClazzes.length != clazzTypes.length || !AbstractGenericFactory.getInstance().isMatching(clazzTypes, parameterClazzes)) continue;
            int modifiers = methods[i].getModifiers();
            if ((!forStatic || !Modifier.isStatic(modifiers)) && (forStatic || Modifier.isStatic(modifiers))) continue;
            return methods[i];
        }
        return AbstractInvoker.getMethodBySlowStrategie(clazz.getSuperclass(), methodName, clazzTypes, forStatic);
    }

    private static Field getField(Class clazz, String fieldName, boolean forStatic) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            int modifiers = field.getModifiers();
            if (forStatic && Modifier.isStatic(modifiers) || !forStatic && !Modifier.isStatic(modifiers)) {
                return field;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return AbstractInvoker.getField(clazz.getSuperclass(), fieldName, forStatic);
    }
}

