/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.mod;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ModConfig {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="entry")
    private String entry;
    @SerializedName(value="dependencies")
    private List<String> requiredDependencies;
    @SerializedName(value="optional_dependencies")
    private List<String> optionalDependencies;
    @SerializedName(value="mixins")
    private List<String> mixins;
    @SerializedName(value="access_wideners")
    private List<String> accessWideners;

    public ModConfig() {
    }

    public ModConfig(@NonNull String id, @NonNull String version) {
        this.id = id;
        this.version = version;
    }

    public ModConfig(@NonNull String id, @NonNull String version, @Nullable String entry, @Nullable List<String> requiredDependencies, @Nullable List<String> optionalDependencies, @Nullable List<String> mixins, @Nullable List<String> accessWideners) {
        this.id = id;
        this.version = version;
        this.entry = entry;
        this.requiredDependencies = requiredDependencies;
        this.optionalDependencies = optionalDependencies;
        this.mixins = mixins;
        this.accessWideners = accessWideners;
    }

    public final @MonotonicNonNull String getId() {
        return this.id;
    }

    public final @MonotonicNonNull String getVersion() {
        return this.version;
    }

    public final @Nullable String getEntry() {
        return this.entry;
    }

    public final @Nullable List<String> getRequiredDependencies() {
        return this.requiredDependencies;
    }

    public final @Nullable List<String> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public final @Nullable List<String> getMixins() {
        return this.mixins;
    }

    public final @Nullable List<String> getAccessWideners() {
        return this.accessWideners;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.version, this.entry, this.requiredDependencies, this.optionalDependencies, this.mixins);
    }

    public final boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModConfig)) {
            return false;
        }
        ModConfig that = (ModConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.entry, that.entry) && Objects.deepEquals(this.requiredDependencies, that.requiredDependencies) && Objects.deepEquals(this.optionalDependencies, that.optionalDependencies) && Objects.deepEquals(this.mixins, that.mixins);
    }

    public final @NonNull String toString() {
        return "ModConfig{id=" + this.id + ", version=" + this.version + ", target=" + this.entry + ", requiredDependencies=" + (this.requiredDependencies != null ? Arrays.toString(this.requiredDependencies.toArray(new String[0])) : "[]") + ", optionalDependencies=" + (this.optionalDependencies != null ? Arrays.toString(this.optionalDependencies.toArray(new String[0])) : "[]") + ", mixins=" + (this.mixins != null ? Arrays.toString(this.mixins.toArray(new String[0])) : "[]") + ", accessWideners=" + (this.accessWideners != null ? Arrays.toString(this.accessWideners.toArray(new String[0])) : "[]") + "}";
    }
}

