/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.ignite.api.config.Configuration;
import space.vectrix.ignite.api.config.ConfigurationKey;

public final class Configurations {
    public static final @NonNull Function<ConfigurationKey, ConfigurationLoader<ConfigurationNode>> GSON_LOADER = key -> Configurations.createLoader(key, path -> ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, SINK_OPTIONS))).setDefaultOptions(ConfigurationOptions.defaults())).build());
    public static final @NonNull Function<ConfigurationKey, ConfigurationLoader<CommentedConfigurationNode>> HOCON_LOADER = key -> Configurations.createLoader(key, path -> ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, SINK_OPTIONS))).setDefaultOptions(ConfigurationOptions.defaults())).build());
    public static final @NonNull Function<ConfigurationKey, ConfigurationLoader<ConfigurationNode>> YAML_LOADER = key -> Configurations.createLoader(key, path -> ((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, SINK_OPTIONS))).setDefaultOptions(ConfigurationOptions.defaults())).build());
    private static final ConcurrentMap<ConfigurationKey, Configuration<?, ?>> CONFIGURATIONS = new ConcurrentHashMap();
    private static final OpenOption[] SINK_OPTIONS = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.DSYNC};

    public static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> createVirtual(@NonNull ConfigurationKey key, @NonNull Class<T> instanceType) {
        return new Configuration(key, instanceType);
    }

    public static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> getOrCreate(@Nullable ConfigurationLoader<N> loader, @NonNull ConfigurationKey key, @NonNull Class<T> instanceType) {
        return Configurations.loadConfiguration(ignored -> loader, key, instanceType);
    }

    public static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> getOrCreate(@NonNull Function<ConfigurationKey, ConfigurationLoader<N>> loaderSupplier, @NonNull ConfigurationKey key, @NonNull Class<T> instanceType) {
        return Configurations.loadConfiguration(loaderSupplier, key, instanceType);
    }

    private static <T, N extends ConfigurationNode> @NonNull Configuration<T, N> loadConfiguration(@NonNull Function<ConfigurationKey, ConfigurationLoader<N>> loaderSupplier, @NonNull ConfigurationKey key, @NonNull Class<T> instanceType) {
        return CONFIGURATIONS.computeIfAbsent(key, ignored -> {
            try {
                Configuration configuration = new Configuration(key, instanceType, (ConfigurationLoader)loaderSupplier.apply(key));
                configuration.load();
                return configuration;
            }
            catch (IOException | ObjectMappingException exception) {
                throw new AssertionError("Unable to load configuration.", exception);
            }
        });
    }

    private static <N extends ConfigurationNode, L extends AbstractConfigurationLoader<N>> L createLoader(@NonNull ConfigurationKey key, @NonNull Function<Path, L> loader) {
        Path path = key.getPath();
        if (path == null) {
            return null;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return (L)((AbstractConfigurationLoader)loader.apply(path));
        }
        catch (IOException exception) {
            throw new AssertionError("Unable to create configuration directory.", exception);
        }
    }
}

