/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.ignite.api.config;

import java.io.IOException;
import java.util.Objects;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.ignite.api.config.ConfigurationKey;

public final class Configuration<T, N extends ConfigurationNode> {
    private final @Nullable ConfigurationLoader<N> loader;
    private final ObjectMapper<T> mapper;
    private final ConfigurationKey key;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @MonotonicNonNull ObjectMapper.BoundInstance instance;
    private @MonotonicNonNull N node;

    private static <T> ObjectMapper<T> createMapper(Class<T> instanceType) {
        try {
            return ObjectMapper.forClass(instanceType);
        }
        catch (ObjectMappingException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    Configuration(@NonNull ConfigurationKey key, @NonNull Class<T> instanceType) {
        this(key, instanceType, null);
    }

    Configuration(@NonNull ConfigurationKey key, @NonNull Class<T> instanceType, @Nullable ConfigurationLoader<N> loader) {
        this.mapper = Configuration.createMapper(instanceType);
        this.key = key;
        this.loader = loader;
    }

    public void load() throws IOException, ObjectMappingException {
        if (this.loader == null) {
            return;
        }
        if (this.instance == null) {
            this.instance = this.mapper.bindToNew();
        }
        this.node = this.loader.load();
        this.instance.populate(this.node);
        this.save();
    }

    public void save() throws IOException, ObjectMappingException {
        if (this.loader == null) {
            return;
        }
        if (this.node == null) {
            this.node = this.loader.createEmptyNode();
        }
        if (this.instance != null) {
            this.instance.serialize(this.node);
        }
        this.loader.save(this.node);
    }

    public @NonNull ConfigurationKey getKey() {
        return this.key;
    }

    public @MonotonicNonNull T getInstance() {
        return (T)(this.instance != null ? this.instance.getInstance() : null);
    }

    public @MonotonicNonNull N getNode() {
        return this.node;
    }

    public int hashCode() {
        return Objects.hash(this.loader, this.mapper, this.key, this.instance, this.node);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)other;
        return Objects.equals(this.loader, that.loader) && Objects.equals(this.mapper, that.mapper) && Objects.equals(this.key, that.key) && Objects.equals(this.instance, that.instance) && Objects.equals(this.node, that.node);
    }

    public String toString() {
        return "Configuration{loader=" + this.loader + ", mapper=" + this.mapper + ", key=" + this.key + ", instance=" + this.instance + ", node=" + this.node + "}";
    }
}

