/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMaps;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Float2ObjectSyncMap;

final class Float2ObjectSyncMapImpl<V>
extends AbstractFloat2ObjectMap<V>
implements Float2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final transient Object lock = new Object();
    private volatile transient Float2ObjectMap<Float2ObjectSyncMap.ExpungingEntry<V>> read;
    private volatile transient boolean amended;
    private transient Float2ObjectMap<Float2ObjectSyncMap.ExpungingEntry<V>> dirty;
    private transient int misses;
    private final transient IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingEntry<V>>> function;
    private transient EntrySetView entrySet;

    Float2ObjectSyncMapImpl(@NonNull IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingEntry<V>>> function, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        this.function = function;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promote();
        int size = 0;
        for (Float2ObjectSyncMap.ExpungingEntry value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        this.promote();
        for (Float2ObjectSyncMap.ExpungingEntry value : this.read.values()) {
            if (!value.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean containsValue(@Nullable Object value) {
        for (Float2ObjectMap.Entry entry : this.float2ObjectEntrySet()) {
            if (!Objects.equals(entry.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(float key) {
        Float2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null && entry.exists();
    }

    public @Nullable V get(float key) {
        Float2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null ? (V)entry.get() : null;
    }

    public @NonNull V getOrDefault(float key, @NonNull V defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Float2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null ? entry.getOr(defaultValue) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Float2ObjectSyncMap.ExpungingEntry<V> getEntry(float key) {
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfAbsent(float key, @NonNull DoubleFunction<? extends V> mappingFunction) {
        Float2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Float2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.computeIfAbsent(key, mappingFunction) : null;
        if (result == null || result.operation() == 2) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry != null) {
                    if (entry.tryUnexpungeAndCompute(key, mappingFunction)) {
                        if (entry.exists()) {
                            this.dirty.put(key, (Object)entry);
                        }
                        return entry.get();
                    }
                    result = entry.computeIfAbsent(key, mappingFunction);
                } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                    result = entry.computeIfAbsent(key, mappingFunction);
                    if (result.current() == null) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                } else {
                    V computed;
                    if (!this.amended) {
                        this.dirtyLocked();
                        this.amended = true;
                    }
                    if ((computed = mappingFunction.apply(key)) != null) {
                        this.dirty.put(key, new ExpungingEntryImpl<V>(computed));
                    }
                    return computed;
                }
            }
        }
        return result.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfAbsent(float key, @NonNull Float2ObjectFunction<? extends V> mappingFunction) {
        Float2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Float2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.computeIfAbsentPrimitive(key, mappingFunction) : null;
        if (result == null || result.operation() == 2) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry != null) {
                    if (entry.tryUnexpungeAndComputePrimitive(key, mappingFunction)) {
                        if (entry.exists()) {
                            this.dirty.put(key, (Object)entry);
                        }
                        return entry.get();
                    }
                    result = entry.computeIfAbsentPrimitive(key, mappingFunction);
                } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                    result = entry.computeIfAbsentPrimitive(key, mappingFunction);
                    if (result.current() == null) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                } else {
                    Object computed;
                    if (!this.amended) {
                        this.dirtyLocked();
                        this.amended = true;
                    }
                    if ((computed = mappingFunction.get(key)) != null) {
                        this.dirty.put(key, new ExpungingEntryImpl<Object>(computed));
                    }
                    return (V)computed;
                }
            }
        }
        return result != null ? (V)result.current() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfPresent(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
        Float2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Float2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.computeIfPresent(key, remappingFunction) : null;
        if (result == null || result.operation() == 2) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry != null) {
                    result = entry.computeIfPresent(key, remappingFunction);
                } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                    result = entry.computeIfPresent(key, remappingFunction);
                    if (result.current() == null) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                }
            }
        }
        return result != null ? (V)result.current() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V compute(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
        Float2ObjectSyncMap.InsertionResult<Object> result;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Float2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.compute(key, remappingFunction) : null;
        if (result == null || result.operation() == 2) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry != null) {
                    if (entry.tryUnexpungeAndCompute(key, remappingFunction)) {
                        if (entry.exists()) {
                            this.dirty.put(key, (Object)entry);
                        }
                        return entry.get();
                    }
                    result = entry.compute(key, remappingFunction);
                } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                    result = entry.compute(key, remappingFunction);
                    if (result.current() == null) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                } else {
                    V computed;
                    if (!this.amended) {
                        this.dirtyLocked();
                        this.amended = true;
                    }
                    if ((computed = remappingFunction.apply(Float.valueOf(key), null)) != null) {
                        this.dirty.put(key, new ExpungingEntryImpl<V>(computed));
                    }
                    return computed;
                }
            }
        }
        return result.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V putIfAbsent(float key, @NonNull V value) {
        Float2ObjectSyncMap.InsertionResult<V> result;
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Float2ObjectSyncMap.InsertionResult<V> insertionResult = result = entry != null ? entry.setIfAbsent(value) : null;
        if (result == null || result.operation() == 2) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry != null) {
                    if (entry.tryUnexpungeAndSet(value)) {
                        this.dirty.put(key, (Object)entry);
                    } else {
                        result = entry.setIfAbsent(value);
                    }
                } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                    result = entry.setIfAbsent(value);
                    this.missLocked();
                } else {
                    if (!this.amended) {
                        this.dirtyLocked();
                        this.amended = true;
                    }
                    this.dirty.put(key, new ExpungingEntryImpl<V>(value));
                }
            }
        }
        return result != null ? (V)result.previous() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V put(float key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value)) {
            return previous;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry != null) {
                previous = entry.get();
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                } else {
                    entry.set(value);
                }
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                previous = entry.get();
                entry.set(value);
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, new ExpungingEntryImpl<V>(value));
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V remove(float key) {
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(float key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    boolean present;
                    entry = (Float2ObjectSyncMap.ExpungingEntry)this.dirty.get(key);
                    boolean bl = present = entry != null && entry.replace(value, null);
                    if (present) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                    return present;
                }
            }
        }
        return entry != null && entry.replace(value, null);
    }

    public @Nullable V replace(float key, @NonNull V value) {
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null ? (V)entry.tryReplace(value) : null;
    }

    public boolean replace(float key, @NonNull V oldValue, @NonNull V newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        Float2ObjectSyncMap.ExpungingEntry<V> entry = this.getEntry(key);
        return entry != null && entry.replace(oldValue, newValue);
    }

    public void forEach(@NonNull BiConsumer<? super Float, ? super V> action) {
        Objects.requireNonNull(action, "action");
        this.promote();
        for (Float2ObjectMap.Entry that : this.read.float2ObjectEntrySet()) {
            Object value = ((Float2ObjectSyncMap.ExpungingEntry)that.getValue()).get();
            if (value == null) continue;
            action.accept(Float.valueOf(that.getFloatKey()), value);
        }
    }

    public void putAll(@NonNull Map<? extends Float, ? extends V> map) {
        Objects.requireNonNull(map, "map");
        for (Map.Entry<Float, V> entry : map.entrySet()) {
            this.put(entry.getKey().floatValue(), entry.getValue());
        }
    }

    public void replaceAll(@NonNull BiFunction<? super Float, ? super V, ? extends V> function) {
        Objects.requireNonNull(function, "function");
        this.promote();
        for (Float2ObjectMap.Entry that : this.read.float2ObjectEntrySet()) {
            Float2ObjectSyncMap.ExpungingEntry entry = (Float2ObjectSyncMap.ExpungingEntry)that.getValue();
            Object value = entry.get();
            if (value == null) continue;
            entry.tryReplace(function.apply(Float.valueOf(that.getFloatKey()), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.dirty = null;
            this.amended = false;
            this.misses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<// Could not load outer class - annotation placement on inner may be incorrect
    Float2ObjectMap.Entry<V>> float2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySetView();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promote() {
        if (this.amended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.amended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void promoteLocked() {
        if (this.dirty != null) {
            this.read = this.dirty;
        }
        this.amended = false;
        this.dirty = null;
        this.misses = 0;
    }

    private void missLocked() {
        if (++this.misses >= this.dirty.size()) {
            this.promoteLocked();
        }
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Float2ObjectMaps.fastForEach(this.read, entry -> {
            if (!((Float2ObjectSyncMap.ExpungingEntry)entry.getValue()).tryExpunge()) {
                this.dirty.put(entry.getFloatKey(), (Object)((Float2ObjectSyncMap.ExpungingEntry)entry.getValue()));
            }
        });
    }

    final class EntryIterator
    implements ObjectIterator<Float2ObjectMap.Entry<V>> {
        private final Iterator<Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingEntry<V>>> backingIterator;
        private Float2ObjectMap.Entry<V> next;
        private Float2ObjectMap.Entry<V> current;

        EntryIterator(Iterator<Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingEntry<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            this.next = this.nextValue();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Float2ObjectMap.Entry<V> next() {
            this.current = this.next;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.nextValue();
            return this.current;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Float2ObjectMap.Entry<V> nextValue() {
            while (this.backingIterator.hasNext()) {
                Float2ObjectMap.Entry entry = this.backingIterator.next();
                Object value = ((Float2ObjectSyncMap.ExpungingEntry)entry.getValue()).get();
                if (value == null) continue;
                return new MapEntry(entry.getFloatKey(), value);
            }
            return null;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Float2ObjectSyncMapImpl.this.remove(this.current.getFloatKey());
            this.current = null;
        }

        public void forEachRemaining(@NonNull Consumer<? super // Could not load outer class - annotation placement on inner may be incorrect
        Float2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action, "action");
            if (this.next != null) {
                action.accept(this.next);
            }
            this.backingIterator.forEachRemaining((? super E entry) -> {
                Object value = ((Float2ObjectSyncMap.ExpungingEntry)entry.getValue()).get();
                if (value != null) {
                    action.accept(new MapEntry(entry.getFloatKey(), value));
                }
            });
        }
    }

    final class EntrySetView
    extends AbstractObjectSet<Float2ObjectMap.Entry<V>> {
        EntrySetView() {
        }

        public int size() {
            return Float2ObjectSyncMapImpl.this.size();
        }

        public boolean contains(@Nullable Object entry) {
            if (!(entry instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry mapEntry = (Float2ObjectMap.Entry)entry;
            Object value = Float2ObjectSyncMapImpl.this.get(mapEntry.getFloatKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        public boolean remove(@Nullable Object entry) {
            if (!(entry instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry mapEntry = (Float2ObjectMap.Entry)entry;
            return Float2ObjectSyncMapImpl.this.remove(mapEntry.getFloatKey()) != null;
        }

        public void clear() {
            Float2ObjectSyncMapImpl.this.clear();
        }

        public @NonNull ObjectIterator<// Could not load outer class - annotation placement on inner may be incorrect
        Float2ObjectMap.Entry<V>> iterator() {
            Float2ObjectSyncMapImpl.this.promote();
            return new EntryIterator(Float2ObjectSyncMapImpl.this.read.float2ObjectEntrySet().iterator());
        }
    }

    final class MapEntry
    implements Float2ObjectMap.Entry<V> {
        private final float key;
        private V value;

        MapEntry(@NonNull float key, V value) {
            this.key = key;
            this.value = value;
        }

        public float getFloatKey() {
            return this.key;
        }

        public @NonNull V getValue() {
            return this.value;
        }

        public @Nullable V setValue(@NonNull V value) {
            Objects.requireNonNull(value, "value");
            this.value = value;
            return Float2ObjectSyncMapImpl.this.put(this.key, this.value);
        }

        public @NonNull String toString() {
            return "Float2ObjectSyncMapImpl.MapEntry{key=" + this.getFloatKey() + ", value=" + this.getValue() + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry that = (Float2ObjectMap.Entry)other;
            return Objects.equals(Float.valueOf(this.getFloatKey()), Float.valueOf(that.getFloatKey())) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.getFloatKey()), this.getValue());
        }
    }

    static final class InsertionResultImpl<V>
    implements Float2ObjectSyncMap.InsertionResult<V> {
        private static final byte UNCHANGED = 0;
        private static final byte UPDATED = 1;
        private static final byte EXPUNGED = 2;
        private final byte operation;
        private final V previous;
        private final V current;

        InsertionResultImpl(byte operation, @Nullable V previous, @Nullable V current) {
            this.operation = operation;
            this.previous = previous;
            this.current = current;
        }

        @Override
        public byte operation() {
            return this.operation;
        }

        @Override
        public @Nullable V previous() {
            return this.previous;
        }

        @Override
        public @Nullable V current() {
            return this.current;
        }
    }

    static final class ExpungingEntryImpl<V>
    implements Float2ObjectSyncMap.ExpungingEntry<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingEntryImpl, Object> UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingEntryImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        ExpungingEntryImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public boolean exists() {
            return this.value != null && this.value != EXPUNGED;
        }

        @Override
        public @Nullable V get() {
            return (V)(this.value == EXPUNGED ? null : this.value);
        }

        @Override
        public @NonNull V getOr(@NonNull V other) {
            Object value = this.value;
            return (V)(value != null && value != EXPUNGED ? this.value : other);
        }

        @Override
        public @NonNull Float2ObjectSyncMap.InsertionResult<V> setIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, value));
            return new InsertionResultImpl<Object>(1, null, value);
        }

        @Override
        public @NonNull Float2ObjectSyncMap.InsertionResult<V> computeIfAbsent(float key, @NonNull DoubleFunction<? extends V> function) {
            Object next = null;
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, next != null ? next : (next = (Object)function.apply(key))));
            return new InsertionResultImpl<Object>(1, null, next);
        }

        @Override
        public @NonNull Float2ObjectSyncMap.InsertionResult<V> computeIfAbsentPrimitive(float key, @NonNull Float2ObjectFunction<? extends V> function) {
            Object next = null;
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, next != null ? next : (next = function.containsKey(key) ? function.get(key) : null)));
            return new InsertionResultImpl<Object>(1, null, next);
        }

        @Override
        public @NonNull Float2ObjectSyncMap.InsertionResult<V> computeIfPresent(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
            Object previous;
            Object next = null;
            do {
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous != null) continue;
                return new InsertionResultImpl<Object>(0, null, null);
            } while (!UPDATER.compareAndSet(this, previous, next != null ? next : (next = (Object)remappingFunction.apply(Float.valueOf(key), previous))));
            return new InsertionResultImpl<Object>(1, previous, next);
        }

        @Override
        public @NonNull Float2ObjectSyncMap.InsertionResult<V> compute(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
            Object previous;
            Object next = null;
            do {
                if ((previous = this.value) != EXPUNGED) continue;
                return new InsertionResultImpl<Object>(2, null, null);
            } while (!UPDATER.compareAndSet(this, previous, next != null ? next : (next = (Object)remappingFunction.apply(Float.valueOf(key), previous))));
            return new InsertionResultImpl<Object>(previous != next ? (byte)1 : 0, previous, next);
        }

        @Override
        public void set(@NonNull V value) {
            UPDATER.set(this, value);
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V value) {
            Object previous;
            do {
                if ((previous = this.value) != EXPUNGED && Objects.equals(previous, compare)) continue;
                return false;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object previous;
            do {
                if ((previous = this.value) != null && previous != EXPUNGED) continue;
                return null;
            } while (!UPDATER.compareAndSet(this, previous, null));
            return (V)previous;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object previous;
            do {
                if ((previous = this.value) != EXPUNGED) continue;
                return false;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return true;
        }

        @Override
        public @Nullable V tryReplace(@NonNull V value) {
            Object previous;
            do {
                if ((previous = this.value) != null && previous != EXPUNGED) continue;
                return null;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return (V)previous;
        }

        @Override
        public boolean tryExpunge() {
            while (this.value == null) {
                if (!UPDATER.compareAndSet(this, null, EXPUNGED)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndSet(@NonNull V value) {
            return UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        @Override
        public boolean tryUnexpungeAndCompute(float key, @NonNull DoubleFunction<? extends V> function) {
            if (this.value == EXPUNGED) {
                V value = function.apply(key);
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndComputePrimitive(float key, @NonNull Float2ObjectFunction<? extends V> function) {
            if (this.value == EXPUNGED) {
                Object value = function.containsKey(key) ? function.get(key) : null;
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndCompute(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
            if (this.value == EXPUNGED) {
                V value = remappingFunction.apply(Float.valueOf(key), null);
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }
    }
}

