/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.floats.AbstractFloat2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectMaps;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Float2ObjectSyncMap;

final class Float2ObjectSyncMapImpl<V>
extends AbstractFloat2ObjectMap<V>
implements Float2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final transient Object lock = new Object();
    private volatile transient Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>> read;
    private volatile transient boolean amended;
    private transient Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>> dirty;
    private transient int misses;
    private transient EntrySetView entrySet;
    private final IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>>> function;
    private final float promotionFactor;

    Float2ObjectSyncMapImpl(@NonNull IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>>> function, int initialCapacity) {
        this(function, initialCapacity, 1.0f);
    }

    Float2ObjectSyncMapImpl(@NonNull IntFunction<Float2ObjectMap<Float2ObjectSyncMap.ExpungingValue<V>>> function, int initialCapacity, float promotionFactor) {
        if (promotionFactor <= 0.0f || promotionFactor > 1.0f) {
            throw new IllegalArgumentException("Promotion factor must be more than 0 and less than or equal to 1");
        }
        this.function = function;
        this.promotionFactor = promotionFactor;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promoteIfNeeded();
        int size = 0;
        for (Float2ObjectSyncMap.ExpungingValue value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        this.promoteIfNeeded();
        for (Float2ObjectSyncMap.ExpungingValue value : this.read.values()) {
            if (!value.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean containsValue(@Nullable Object value) {
        for (Float2ObjectMap.Entry entry : this.float2ObjectEntrySet()) {
            if (!Objects.equals(entry.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(float key) {
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null && entry.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V get(float key) {
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfAbsent(float key, @NonNull DoubleFunction<? extends V> mappingFunction) {
        Object current;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry != null) {
            Object current2 = entry.get();
            if (current2 == null) {
                current2 = entry.set(mappingFunction.apply(key));
            }
            return current2;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpunge()) {
                    this.dirty.put(key, (Object)entry);
                }
                if ((current = entry.get()) == null) {
                    current = entry.set(mappingFunction.apply(key));
                }
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key)) != null) {
                current = entry.get();
                if (current == null) {
                    current = entry.set(mappingFunction.apply(key));
                }
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                current = mappingFunction.apply(key);
                this.dirty.put(key, new ExpungingValueImpl(current));
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfAbsent(float key, @NonNull Float2ObjectFunction<? extends V> mappingFunction) {
        Object current;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry != null) {
            Object current2 = entry.get();
            if (current2 == null) {
                current2 = entry.set(mappingFunction.get(key));
            }
            return current2;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpunge()) {
                    this.dirty.put(key, (Object)entry);
                }
                if ((current = entry.get()) == null) {
                    current = entry.set(mappingFunction.get(key));
                }
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key)) != null) {
                current = entry.get();
                if (current == null) {
                    current = entry.set(mappingFunction.get(key));
                }
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                current = mappingFunction.get(key);
                this.dirty.put(key, new ExpungingValueImpl(current));
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V computeIfPresent(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
        Object current;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry != null) {
            Object current2 = entry.get();
            if (current2 != null) {
                current2 = remappingFunction.apply(Float.valueOf(key), current2);
                entry.trySet(current2);
            }
            return current2;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                current = entry.get();
                if (current != null) {
                    current = remappingFunction.apply(Float.valueOf(key), current);
                    entry.trySet(current);
                }
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key)) != null) {
                current = entry.get();
                if (current != null) {
                    current = remappingFunction.apply(Float.valueOf(key), current);
                    entry.trySet(current);
                }
                this.missLocked();
            } else {
                current = null;
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V compute(float key, @NonNull BiFunction<? super Float, ? super V, ? extends V> remappingFunction) {
        V current;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry != null) {
            V current2 = entry.set(remappingFunction.apply(Float.valueOf(key), entry.get()));
            return current2;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpunge()) {
                    this.dirty.put(key, (Object)entry);
                }
                current = entry.set(remappingFunction.apply(Float.valueOf(key), entry.get()));
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key)) != null) {
                current = entry.set(remappingFunction.apply(Float.valueOf(key), entry.get()));
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                current = remappingFunction.apply(Float.valueOf(key), null);
                this.dirty.put(key, new ExpungingValueImpl(current));
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V putIfAbsent(float key, @NonNull V value) {
        Map.Entry<Boolean, V> result;
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry != null && (result = entry.putIfAbsent(value)).getKey() == Boolean.TRUE) {
            return result.getValue();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpunge()) {
                    this.dirty.put(key, (Object)entry);
                }
                result = entry.putIfAbsent(value);
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key)) != null) {
                result = entry.putIfAbsent(value);
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, new ExpungingValueImpl(value));
                result = new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, null);
            }
        }
        return result.getValue();
    }

    public @Nullable V put(float key, @NonNull V value) {
        return this.putValue(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putValue(float key, @NonNull V value, boolean onlyIfPresent) {
        V previous;
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value)) {
            return previous;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                previous = entry.get();
                if (onlyIfPresent) {
                    entry.trySet(value);
                } else if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                } else {
                    entry.set(value);
                }
            } else if (this.dirty != null && (entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key)) != null) {
                previous = entry.get();
                entry.set(value);
                this.missLocked();
            } else if (!onlyIfPresent) {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, new ExpungingValueImpl(value));
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable V remove(float key) {
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(float key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    boolean present = entry != null && entry.replace(value, null);
                    if (present) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                    return present;
                }
            }
        }
        return entry != null && entry.replace(value, null);
    }

    public @Nullable V replace(float key, @NonNull V value) {
        return this.putValue(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(float key, @NonNull V currentValue, @NonNull V newValue) {
        Objects.requireNonNull(currentValue, "currentValue");
        Objects.requireNonNull(newValue, "newValue");
        Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Float2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.amended && this.dirty != null) {
                    entry = (Float2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    boolean present = entry != null && entry.replace(currentValue, newValue);
                    this.missLocked();
                    return present;
                }
            }
        }
        return entry != null && entry.replace(currentValue, newValue);
    }

    public void forEach(@NonNull BiConsumer<? super Float, ? super V> action) {
        Objects.requireNonNull(action, "action");
        this.promoteIfNeeded();
        for (Float2ObjectMap.Entry that : this.read.float2ObjectEntrySet()) {
            Object value = ((Float2ObjectSyncMap.ExpungingValue)that.getValue()).get();
            if (value == null) continue;
            action.accept(Float.valueOf(that.getFloatKey()), value);
        }
    }

    public void putAll(@NonNull Map<? extends Float, ? extends V> map) {
        Objects.requireNonNull(map, "map");
        for (Map.Entry<Float, V> entry : map.entrySet()) {
            this.putValue(entry.getKey().floatValue(), entry.getValue(), false);
        }
    }

    public void replaceAll(@NonNull BiFunction<? super Float, ? super V, ? extends V> function) {
        Objects.requireNonNull(function, "function");
        this.promoteIfNeeded();
        for (Float2ObjectMap.Entry that : this.read.float2ObjectEntrySet()) {
            Float2ObjectSyncMap.ExpungingValue entry = (Float2ObjectSyncMap.ExpungingValue)that.getValue();
            Object value = entry.get();
            if (value == null) continue;
            entry.trySet(function.apply(Float.valueOf(that.getFloatKey()), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.amended = false;
            this.dirty = null;
            this.misses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<// Could not load outer class - annotation placement on inner may be incorrect
    Float2ObjectMap.Entry<V>> float2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySetView();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteIfNeeded() {
        if (this.amended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.amended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void promoteLocked() {
        if (this.dirty != null) {
            this.read = this.dirty;
        }
        this.amended = false;
        this.dirty = null;
        this.misses = 0;
    }

    private void missLocked() {
        if (this.misses++ >= (this.dirty != null ? (int)((float)this.dirty.size() * this.promotionFactor) : 0)) {
            this.promoteLocked();
        }
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Float2ObjectMaps.fastForEach(this.read, entry -> {
            if (!((Float2ObjectSyncMap.ExpungingValue)entry.getValue()).tryMarkExpunged()) {
                this.dirty.put(entry.getFloatKey(), (Object)((Float2ObjectSyncMap.ExpungingValue)entry.getValue()));
            }
        });
    }

    private final class EntryIterator
    implements ObjectIterator<Float2ObjectMap.Entry<V>> {
        private final Iterator<Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingValue<V>>> backingIterator;
        private Float2ObjectMap.Entry<V> next;
        private Float2ObjectMap.Entry<V> current;

        private EntryIterator(Iterator<Float2ObjectMap.Entry<Float2ObjectSyncMap.ExpungingValue<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            this.next = this.nextValue();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Float2ObjectMap.Entry<V> next() {
            this.current = this.next;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.next = this.nextValue();
            return this.current;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Float2ObjectMap.Entry<V> nextValue() {
            while (this.backingIterator.hasNext()) {
                Float2ObjectMap.Entry entry = this.backingIterator.next();
                Object value = ((Float2ObjectSyncMap.ExpungingValue)entry.getValue()).get();
                if (value == null) continue;
                return new MapEntry(entry.getFloatKey(), value);
            }
            return null;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Float2ObjectSyncMapImpl.this.remove(this.current.getFloatKey());
            this.current = null;
        }

        public void forEachRemaining(@NonNull Consumer<? super // Could not load outer class - annotation placement on inner may be incorrect
        Float2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action, "action");
            if (this.next != null) {
                action.accept(this.next);
            }
            this.backingIterator.forEachRemaining((? super E entry) -> {
                Object value = ((Float2ObjectSyncMap.ExpungingValue)entry.getValue()).get();
                if (value != null) {
                    action.accept(new MapEntry(entry.getFloatKey(), value));
                }
            });
        }
    }

    private final class EntrySetView
    extends AbstractObjectSet<Float2ObjectMap.Entry<V>> {
        private EntrySetView() {
        }

        public int size() {
            return Float2ObjectSyncMapImpl.this.size();
        }

        public boolean contains(@Nullable Object entry) {
            if (!(entry instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry mapEntry = (Float2ObjectMap.Entry)entry;
            Object value = Float2ObjectSyncMapImpl.this.get(mapEntry.getFloatKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        public boolean remove(@Nullable Object entry) {
            if (!(entry instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry mapEntry = (Float2ObjectMap.Entry)entry;
            return Float2ObjectSyncMapImpl.this.remove(mapEntry.getFloatKey()) != null;
        }

        public void clear() {
            Float2ObjectSyncMapImpl.this.clear();
        }

        public @NonNull ObjectIterator<// Could not load outer class - annotation placement on inner may be incorrect
        Float2ObjectMap.Entry<V>> iterator() {
            Float2ObjectSyncMapImpl.this.promoteIfNeeded();
            return new EntryIterator((Iterator)Float2ObjectSyncMapImpl.this.read.float2ObjectEntrySet().iterator());
        }
    }

    private final class MapEntry
    implements Float2ObjectMap.Entry<V> {
        private final float key;
        private V value;

        private MapEntry(@NonNull float key, V value) {
            this.key = key;
            this.value = value;
        }

        public float getFloatKey() {
            return this.key;
        }

        public @NonNull V getValue() {
            return this.value;
        }

        public @Nullable V setValue(@NonNull V value) {
            Objects.requireNonNull(value, "value");
            this.value = value;
            return Float2ObjectSyncMapImpl.this.put(this.key, this.value);
        }

        public @NonNull String toString() {
            return "Float2ObjectSyncMapImpl.MapEntry{key=" + this.getFloatKey() + ", value=" + this.getValue() + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Float2ObjectMap.Entry)) {
                return false;
            }
            Float2ObjectMap.Entry that = (Float2ObjectMap.Entry)other;
            return Objects.equals(Float.valueOf(this.getFloatKey()), Float.valueOf(that.getFloatKey())) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.getFloatKey()), this.getValue());
        }
    }

    private static final class ExpungingValueImpl<V>
    implements Float2ObjectSyncMap.ExpungingValue<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingValueImpl, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingValueImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        private ExpungingValueImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public @Nullable V get() {
            Object value = VALUE_UPDATER.get(this);
            return (V)(value == EXPUNGED ? null : value);
        }

        @Override
        public @NonNull Map.Entry<Boolean, V> putIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = VALUE_UPDATER.get(this)) == EXPUNGED) {
                    return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.FALSE, null);
                }
                if (previous == null) continue;
                return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, previous);
            } while (!VALUE_UPDATER.compareAndSet(this, null, value));
            return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, null);
        }

        @Override
        public boolean exists() {
            Object value = VALUE_UPDATER.get(this);
            return value != null && value != EXPUNGED;
        }

        @Override
        public @NonNull V set(@NonNull V value) {
            VALUE_UPDATER.set(this, value);
            return value;
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V newValue) {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != EXPUNGED && Objects.equals(value, compare)) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, value, newValue));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != null && value != EXPUNGED) continue;
                return null;
            } while (!VALUE_UPDATER.compareAndSet(this, value, null));
            return (V)value;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object present;
            do {
                if ((present = VALUE_UPDATER.get(this)) != EXPUNGED) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, present, value));
            return true;
        }

        @Override
        public boolean tryMarkExpunged() {
            Object value = VALUE_UPDATER.get(this);
            while (value == null) {
                if (VALUE_UPDATER.compareAndSet(this, null, EXPUNGED)) {
                    return true;
                }
                value = VALUE_UPDATER.get(this);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndSet(@Nullable V value) {
            return VALUE_UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        @Override
        public boolean tryUnexpunge() {
            return VALUE_UPDATER.compareAndSet(this, EXPUNGED, null);
        }

        public String toString() {
            return "Float2ObjectSyncMapImpl.ExpungingValue{value=" + this.get() + "}";
        }
    }
}

