/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.doubles.AbstractDouble2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMaps;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Double2ObjectSyncMap;

final class Double2ObjectSyncMapImpl<V>
extends AbstractDouble2ObjectMap<V>
implements Double2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final Object lock = new Object();
    private final IntFunction<Double2ObjectMap<Double2ObjectSyncMap.ExpungingValue<V>>> function;
    private volatile Double2ObjectMap<Double2ObjectSyncMap.ExpungingValue<V>> read;
    private volatile boolean readAmended;
    private int readMisses;
    private Double2ObjectMap<Double2ObjectSyncMap.ExpungingValue<V>> dirty;
    private EntrySet entrySet;

    Double2ObjectSyncMapImpl(@NonNull IntFunction<Double2ObjectMap<Double2ObjectSyncMap.ExpungingValue<V>>> function, int initialCapacity) {
        this.function = function;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promoteIfNeeded();
        int size = 0;
        for (Double2ObjectSyncMap.ExpungingValue value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(double key) {
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Double2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null && entry.exists();
    }

    public boolean containsValue(@Nullable Object value) {
        ObjectIterator iterator = this.double2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            if (!Objects.equals(((Map.Entry)iterator.next()).getValue(), value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(double key) {
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Double2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.get() : null;
    }

    public V put(double key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value)) {
            return previous;
        }
        return this.putDirty(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V putDirty(double key, @NonNull V value, boolean present) {
        V previous = null;
        Object object = this.lock;
        synchronized (object) {
            Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                previous = entry.get();
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                } else {
                    entry.set(value);
                }
            } else {
                Double2ObjectSyncMap.ExpungingValue expungingValue = entry = this.dirty != null ? (Double2ObjectSyncMap.ExpungingValue)this.dirty.get(key) : null;
                if (entry != null) {
                    previous = entry.get();
                    entry.set(value);
                    this.missLocked();
                } else if (!present) {
                    if (!this.readAmended) {
                        this.dirtyLocked();
                        this.readAmended = true;
                    }
                    if (this.dirty != null && (entry = (Double2ObjectSyncMap.ExpungingValue)this.dirty.put(key, new ExpungingValueImpl(value))) != null) {
                        previous = entry.get();
                    }
                }
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(double key) {
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Double2ObjectSyncMap.ExpungingValue)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry != null ? (V)entry.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(double key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Double2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    entry = entry != null && entry.replace(value, null) ? (Double2ObjectSyncMap.ExpungingValue)this.dirty.remove(key) : null;
                    this.missLocked();
                    return entry != null;
                }
            }
        }
        return entry != null && entry.replace(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(double key, @NonNull V value) {
        Objects.requireNonNull(value, "value");
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        Map.Entry<Boolean, V> result = null;
        if (entry != null && (result = entry.putIfAbsent(value)).getKey() == Boolean.TRUE) {
            return result.getValue();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
            if (entry != null) {
                if (entry.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Object)entry);
                }
            } else {
                Double2ObjectSyncMap.ExpungingValue expungingValue = entry = this.dirty != null ? (Double2ObjectSyncMap.ExpungingValue)this.dirty.get(key) : null;
                if (entry != null) {
                    result = entry.putIfAbsent(value);
                    this.missLocked();
                } else {
                    if (!this.readAmended) {
                        this.dirtyLocked();
                        this.readAmended = true;
                    }
                    if (this.dirty != null) {
                        this.dirty.put(key, new ExpungingValueImpl(value));
                    }
                }
            }
        }
        return result != null ? (V)result.getValue() : null;
    }

    public V replace(double key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        V v = previous = entry != null ? (V)entry.get() : null;
        if (entry != null && entry.trySet(value) || !this.readAmended) {
            return previous;
        }
        return this.putDirty(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(double key, @NonNull V oldValue, @NonNull V newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        Double2ObjectSyncMap.ExpungingValue entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
        if (entry == null && this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                entry = (Double2ObjectSyncMap.ExpungingValue)this.read.get(key);
                if (entry == null && this.readAmended && this.dirty != null) {
                    entry = (Double2ObjectSyncMap.ExpungingValue)this.dirty.get(key);
                    if (entry != null && !entry.replace(oldValue, newValue)) {
                        entry = null;
                    }
                    this.missLocked();
                    return entry != null;
                }
            }
        }
        return entry != null && entry.replace(oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.readAmended = false;
            this.dirty = null;
            this.readMisses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<// Could not load outer class - annotation placement on inner may be incorrect
    Double2ObjectMap.Entry<V>> double2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteIfNeeded() {
        if (this.readAmended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.readAmended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void promoteLocked() {
        if (this.dirty != null) {
            this.read = this.dirty;
        }
        this.readAmended = false;
        this.dirty = null;
        this.readMisses = 0;
    }

    private void missLocked() {
        if (++this.readMisses > (this.dirty != null ? this.dirty.size() : 0)) {
            this.promoteLocked();
        }
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Double2ObjectMaps.fastForEach(this.read, entry -> {
            if (!((Double2ObjectSyncMap.ExpungingValue)entry.getValue()).tryMarkExpunged()) {
                this.dirty.put(entry.getDoubleKey(), (Object)((Double2ObjectSyncMap.ExpungingValue)entry.getValue()));
            }
        });
    }

    private final class EntryIterator
    implements ObjectIterator<Double2ObjectMap.Entry<V>> {
        private final Iterator<Double2ObjectMap.Entry<Double2ObjectSyncMap.ExpungingValue<V>>> backingIterator;
        private Double2ObjectMap.Entry<V> next;
        private Double2ObjectMap.Entry<V> current;

        private EntryIterator(Iterator<Double2ObjectMap.Entry<Double2ObjectSyncMap.ExpungingValue<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            Double2ObjectMap.Entry entry = this.getNextValue();
            this.next = entry != null ? new MapEntry(entry) : null;
        }

        private Double2ObjectMap.Entry<Double2ObjectSyncMap.ExpungingValue<V>> getNextValue() {
            Double2ObjectMap.Entry entry = null;
            while (this.backingIterator.hasNext() && entry == null) {
                entry = this.backingIterator.next();
                Double2ObjectSyncMap.ExpungingValue value = (Double2ObjectSyncMap.ExpungingValue)entry.getValue();
                if (value.exists()) continue;
                entry = null;
            }
            return entry;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Double2ObjectMap.Entry<V> next() {
            this.current = this.next;
            Double2ObjectMap.Entry entry = this.getNextValue();
            MapEntry mapEntry = this.next = entry != null ? new MapEntry(entry) : null;
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                return;
            }
            Double2ObjectSyncMapImpl.this.remove(this.current.getDoubleKey());
        }

        public void forEachRemaining(@NonNull Consumer<? super // Could not load outer class - annotation placement on inner may be incorrect
        Double2ObjectMap.Entry<V>> action) {
            if (this.next != null) {
                action.accept(this.next);
            }
            this.backingIterator.forEachRemaining((? super E entry) -> {
                if (((Double2ObjectSyncMap.ExpungingValue)entry.getValue()).exists()) {
                    action.accept(new MapEntry((Double2ObjectMap.Entry)entry));
                }
            });
        }
    }

    private final class EntrySet
    extends AbstractObjectSet<Double2ObjectMap.Entry<V>> {
        private EntrySet() {
        }

        public int size() {
            return Double2ObjectSyncMapImpl.this.size();
        }

        public boolean contains(@Nullable Object entry) {
            if (!(entry instanceof Double2ObjectMap.Entry)) {
                return false;
            }
            Double2ObjectMap.Entry mapEntry = (Double2ObjectMap.Entry)entry;
            Object value = Double2ObjectSyncMapImpl.this.get(mapEntry.getDoubleKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        public boolean remove(@Nullable Object entry) {
            if (!(entry instanceof Double2ObjectMap.Entry)) {
                return false;
            }
            Double2ObjectMap.Entry mapEntry = (Double2ObjectMap.Entry)entry;
            return Double2ObjectSyncMapImpl.this.remove(mapEntry.getDoubleKey()) != null;
        }

        public void clear() {
            Double2ObjectSyncMapImpl.this.clear();
        }

        public @NonNull ObjectIterator<// Could not load outer class - annotation placement on inner may be incorrect
        Double2ObjectMap.Entry<V>> iterator() {
            Double2ObjectSyncMapImpl.this.promoteIfNeeded();
            return new EntryIterator((Iterator)Double2ObjectSyncMapImpl.this.read.double2ObjectEntrySet().iterator());
        }
    }

    private final class MapEntry
    implements Double2ObjectMap.Entry<V> {
        private final double key;

        private MapEntry(Double2ObjectMap.Entry<Double2ObjectSyncMap.ExpungingValue<V>> entry) {
            this.key = entry.getDoubleKey();
        }

        public double getDoubleKey() {
            return this.key;
        }

        public @Nullable V getValue() {
            return Double2ObjectSyncMapImpl.this.get(this.key);
        }

        public @Nullable V setValue(@NonNull V value) {
            return Double2ObjectSyncMapImpl.this.put(this.key, value);
        }

        public @NonNull String toString() {
            return "Double2ObjectSyncMapImpl.MapEntry{key=" + this.getDoubleKey() + ", value=" + this.getValue() + "}";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Double2ObjectMap.Entry)) {
                return false;
            }
            Double2ObjectMap.Entry that = (Double2ObjectMap.Entry)other;
            return Objects.equals(this.getDoubleKey(), that.getDoubleKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getDoubleKey(), this.getValue());
        }
    }

    private static final class ExpungingValueImpl<V>
    implements Double2ObjectSyncMap.ExpungingValue<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingValueImpl, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingValueImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        private ExpungingValueImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public @Nullable V get() {
            Object value = VALUE_UPDATER.get(this);
            return (V)(value == EXPUNGED ? null : value);
        }

        @Override
        public  @NonNull Map.Entry<Boolean, V> putIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = VALUE_UPDATER.get(this)) == EXPUNGED) {
                    return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.FALSE, null);
                }
                if (previous == null) continue;
                return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, previous);
            } while (!VALUE_UPDATER.compareAndSet(this, null, value));
            return new AbstractMap.SimpleImmutableEntry<Boolean, Object>(Boolean.TRUE, null);
        }

        @Override
        public boolean expunged() {
            return VALUE_UPDATER.get(this) == EXPUNGED;
        }

        @Override
        public boolean exists() {
            Object value = VALUE_UPDATER.get(this);
            return value != null && value != EXPUNGED;
        }

        @Override
        public void set(@NonNull V value) {
            VALUE_UPDATER.set(this, value);
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V newValue) {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != EXPUNGED && Objects.equals(value, compare)) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, value, newValue));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object value;
            do {
                if ((value = VALUE_UPDATER.get(this)) != null && value != EXPUNGED) continue;
                return null;
            } while (!VALUE_UPDATER.compareAndSet(this, value, null));
            return (V)value;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object present;
            do {
                if ((present = VALUE_UPDATER.get(this)) != EXPUNGED) continue;
                return false;
            } while (!VALUE_UPDATER.compareAndSet(this, present, value));
            return true;
        }

        @Override
        public boolean tryMarkExpunged() {
            Object value = VALUE_UPDATER.get(this);
            while (value == null) {
                if (VALUE_UPDATER.compareAndSet(this, null, EXPUNGED)) {
                    return true;
                }
                value = VALUE_UPDATER.get(this);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndSet(@Nullable V value) {
            return VALUE_UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        public String toString() {
            return "Double2ObjectSyncMapImpl.ExpungingValue{value=" + this.get() + "}";
        }
    }
}

