/*
 * Decompiled with CFR 0.152.
 */
package space.tanghy.cascade.lib.dialog;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import space.tanghy.cascade.lib.dialog.CascadePickerView;
import space.tanghy.cascade.lib.dialog.Item;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lspace/tanghy/cascade/lib/dialog/CityPickerView;", "Lspace/tanghy/cascade/lib/dialog/CascadePickerView;", "context", "Landroid/content/Context;", "level", "", "(Landroid/content/Context;I)V", "(Landroid/content/Context;)V", "parseJsonFile", "", "Lspace/tanghy/cascade/lib/dialog/Item;", "fileName", "", "lib_release"})
public final class CityPickerView
extends CascadePickerView {
    public CityPickerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.setSearchChildren((Function1<? super Item, ? extends List<Item>>)((Function1)new Function1<Item, List<Item>>(){

            @NotNull
            public final List<Item> invoke(@NotNull Item it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.parseJsonFile(it.getValue().toString());
            }
        }));
        this.setData(this.parseJsonFile("province"));
    }

    public CityPickerView(@NotNull Context context, int level) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context);
        this.setLevel(level);
    }

    @NotNull
    public final List<Item> parseJsonFile(@NotNull String fileName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            InputStream inputStream = this.getContext().getAssets().open(Intrinsics.stringPlus((String)fileName, (Object)".json"));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(\"${fileName}.json\")");
            InputStream input = inputStream;
            int size = input.available();
            byte[] buffer = new byte[size];
            input.read(buffer);
            input.close();
            Charset charset = Charset.forName("utf-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"utf-8\")");
            String jsonStr = new String(buffer, charset);
            object = new Gson().fromJson(jsonStr, new TypeToken<List<Item>>(){}.getType());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            val input \u2026em>>() {}.type)\n        }");
            object = (List)object;
        }
        catch (IOException e) {
            object = new ArrayList();
        }
        return object;
    }
}

