/*
 * Decompiled with CFR 0.152.
 */
package space.tanghy.cascade.lib.utils;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.view.WindowMetrics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lspace/tanghy/cascade/lib/utils/ScreenUtil;", "", "()V", "getHeight", "", "context", "Landroid/content/Context;", "getWidth", "lib_release"})
public final class ScreenUtil {
    @NotNull
    public static final ScreenUtil INSTANCE = new ScreenUtil();

    private ScreenUtil() {
    }

    public final int getWidth(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            n = windowMetrics2.getBounds().width();
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.widthPixels;
        }
        return n;
    }

    public final int getHeight(@NotNull Context context) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            n = windowMetrics2.getBounds().height();
        } else {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.heightPixels;
        }
        return n;
    }
}

