/*
 * Decompiled with CFR 0.152.
 */
package space.tanghy.cascade.lib.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import space.tanghy.cascade.lib.R;
import space.tanghy.cascade.lib.dialog.CascadeAdapter;
import space.tanghy.cascade.lib.dialog.Item;
import space.tanghy.cascade.lib.dialog.TabItem;
import space.tanghy.cascade.lib.utils.ScreenUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0014H\u0002J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\fH\u0002J\b\u0010'\u001a\u00020\u0015H\u0002J\u0012\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010*H\u0014J\u000e\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-J\u0014\u0010+\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\fJ\u000e\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020\fJ$\u00102\u001a\u00020\u00152\u001c\b\u0002\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\bJ\u001c\u00103\u001a\u00020\u00152\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\bJ(\u00104\u001a\u00020\u00152 \u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0017\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001dR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0017\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lspace/tanghy/cascade/lib/dialog/CascadePickerView;", "Landroid/app/Dialog;", "context", "Landroid/content/Context;", "data", "", "Lspace/tanghy/cascade/lib/dialog/Item;", "searchChildren", "Lkotlin/Function1;", "(Landroid/content/Context;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "(Landroid/content/Context;)V", "displayLevel", "", "lastItemCloseDialog", "", "getLastItemCloseDialog", "()Z", "setLastItemCloseDialog", "(Z)V", "selectItemListener", "Lspace/tanghy/cascade/lib/dialog/TabItem;", "", "selectItems", "", "getSelectItems", "()Ljava/util/List;", "setSelectItems", "(Ljava/util/List;)V", "selectLastListener", "Lkotlin/Function2;", "tabData", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "viewPager", "Landroidx/viewpager2/widget/ViewPager2;", "changeTabItem", "tabItem", "handlerOnClick", "tabIndex", "initView", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setData", "dataJson", "", "setGravity", "gravity", "setLevel", "level", "setSearchChildren", "setSelectItemListener", "setSelectLastListener", "lib_release"})
public class CascadePickerView
extends Dialog {
    @Nullable
    private TabLayout tabLayout;
    @Nullable
    private ViewPager2 viewPager;
    @NotNull
    private List<Item> data;
    @NotNull
    private List<TabItem> tabData;
    @Nullable
    private Function2<? super TabItem, ? super List<Item>, Unit> selectLastListener;
    @Nullable
    private Function1<? super TabItem, Unit> selectItemListener;
    @Nullable
    private Function1<? super Item, ? extends List<Item>> searchChildren;
    private int displayLevel;
    @Nullable
    private List<Item> selectItems;
    private boolean lastItemCloseDialog;

    public CascadePickerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, R.style.dialogTheme);
        this.data = new ArrayList();
        this.tabData = new ArrayList();
        this.displayLevel = Integer.MAX_VALUE;
        this.lastItemCloseDialog = true;
    }

    @Nullable
    public final List<Item> getSelectItems() {
        return this.selectItems;
    }

    public final void setSelectItems(@Nullable List<Item> list) {
        this.selectItems = list;
    }

    public final boolean getLastItemCloseDialog() {
        return this.lastItemCloseDialog;
    }

    public final void setLastItemCloseDialog(boolean bl) {
        this.lastItemCloseDialog = bl;
    }

    public CascadePickerView(@NotNull Context context, @NotNull List<Item> data, @Nullable Function1<? super Item, ? extends List<Item>> searchChildren) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this(context);
        this.data = data;
        this.searchChildren = searchChildren;
    }

    public /* synthetic */ CascadePickerView(Context context, List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(context, list, (Function1<? super Item, ? extends List<Item>>)function1);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_layout);
        Window window = this.getWindow();
        if (window != null) {
            window.setGravity(80);
        }
        Window window2 = this.getWindow();
        if (window2 != null) {
            window2.setWindowAnimations(R.style.dialog_animStyle);
        }
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int height = ScreenUtil.INSTANCE.getHeight(context);
        Window window3 = this.getWindow();
        if (window3 != null) {
            window3.setLayout(-1, height / 3);
        }
        this.initView();
        this.setData(this.data);
    }

    private final void initView() {
        TabLayout tabLayout = this.tabLayout = (TabLayout)this.findViewById(R.id.auto_tab_layout);
        if (tabLayout != null) {
            tabLayout.setTabIndicatorFullWidth(false);
        }
        ViewPager2 viewPager2 = this.viewPager = (ViewPager2)this.findViewById(R.id.pager);
        if (viewPager2 != null) {
            viewPager2.requestDisallowInterceptTouchEvent(true);
        }
    }

    @NotNull
    public final CascadePickerView setGravity(int gravity) {
        Window window = this.getWindow();
        if (window != null) {
            window.setGravity(gravity);
        }
        return this;
    }

    public final void setSelectLastListener(@Nullable Function2<? super TabItem, ? super List<Item>, Unit> selectLastListener) {
        this.selectLastListener = selectLastListener;
    }

    public final void setSelectItemListener(@Nullable Function1<? super TabItem, Unit> selectItemListener) {
        this.selectItemListener = selectItemListener;
    }

    public final void setSearchChildren(@Nullable Function1<? super Item, ? extends List<Item>> searchChildren) {
        this.searchChildren = searchChildren;
    }

    public static /* synthetic */ void setSearchChildren$default(CascadePickerView cascadePickerView, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setSearchChildren");
        }
        if ((n & 1) != 0) {
            function1 = null;
        }
        cascadePickerView.setSearchChildren((Function1<? super Item, ? extends List<Item>>)function1);
    }

    public final void setData(@NotNull String dataJson) {
        Intrinsics.checkNotNullParameter((Object)dataJson, (String)"dataJson");
        List dataList2 = (List)new Gson().fromJson(dataJson, new TypeToken<List<Item>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)dataList2, (String)"dataList");
        this.setData(dataList2);
    }

    @NotNull
    public final CascadePickerView setData(@NotNull List<Item> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        if (this.tabLayout != null) {
            TabLayout tabLayout = this.tabLayout;
            if (tabLayout != null) {
                tabLayout.removeAllTabs();
            }
            this.tabData.clear();
            this.tabData.add(new TabItem("\u8bf7\u9009\u62e9", data, 0, null, 12, null));
            CascadeAdapter adapter2 = new CascadeAdapter(this.tabData, (Function1<? super TabItem, Unit>)((Function1)new Function1<TabItem, Unit>(this){
                final /* synthetic */ CascadePickerView this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull TabItem tabItem) {
                    Intrinsics.checkNotNullParameter((Object)tabItem, (String)"tabItem");
                    int tabIndex = CascadePickerView.access$changeTabItem(this.this$0, tabItem);
                    CascadePickerView.access$handlerOnClick(this.this$0, tabItem, tabIndex);
                }
            }));
            ViewPager2 viewPager2 = this.viewPager;
            if (viewPager2 != null) {
                viewPager2.setAdapter((RecyclerView.Adapter)adapter2);
            }
            TabLayout tabLayout2 = this.tabLayout;
            Intrinsics.checkNotNull((Object)tabLayout2);
            ViewPager2 viewPager22 = this.viewPager;
            Intrinsics.checkNotNull((Object)viewPager22);
            new TabLayoutMediator(tabLayout2, viewPager22, (arg_0, arg_1) -> CascadePickerView.setData$lambda-0(this, arg_0, arg_1)).attach();
        }
        return this;
    }

    public final void setLevel(int level) {
        this.displayLevel = level;
    }

    /*
     * WARNING - void declaration
     */
    private final void handlerOnClick(TabItem tabItem, int tabIndex) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TabItem it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this.tabData;
        CascadePickerView cascadePickerView = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TabItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getCurrentItem() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TabItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Item item = it.getCurrentItem();
            Intrinsics.checkNotNull((Object)item);
            collection.add(item);
        }
        cascadePickerView.selectItems = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Function1<? super TabItem, Unit> function1 = this.selectItemListener;
        if (function1 != null) {
            function1.invoke((Object)tabItem);
        }
        if (tabIndex > -1) {
            ViewPager2 viewPager2 = this.viewPager;
            if (viewPager2 != null) {
                viewPager2.setCurrentItem(tabIndex, true);
            }
        } else {
            Function2<? super TabItem, ? super List<Item>, Unit> function2 = this.selectLastListener;
            if (function2 != null) {
                List<Item> list = this.selectItems;
                Intrinsics.checkNotNull(list);
                function2.invoke((Object)tabItem, list);
            }
            if (this.lastItemCloseDialog) {
                this.hide();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int changeTabItem(TabItem tabItem) {
        void $this$filterTo$iv$iv2;
        Item currentItem;
        Item item = currentItem = tabItem.getCurrentItem();
        Intrinsics.checkNotNull((Object)item);
        tabItem.setName(item.getName());
        Iterable $this$filter$iv = this.tabData;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            TabItem it = (TabItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getIndex() <= tabItem.getIndex())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toMutableList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int oldLen = this.tabData.size();
        this.tabData.clear();
        this.tabData.addAll(toMutableList);
        ViewPager2 viewPager2 = this.viewPager;
        if (viewPager2 != null) {
            RecyclerView.Adapter adapter2 = viewPager2.getAdapter();
            if (adapter2 != null) {
                adapter2.notifyItemRangeRemoved(tabItem.getIndex() + 1, oldLen - this.tabData.size());
            }
        }
        int tabIndex = -1;
        if (currentItem.getChildren() != null && this.tabData.size() < this.displayLevel) {
            tabIndex = this.tabData.size();
            int $this$filterTo$iv$iv2 = this.tabData.size();
            List<Item> list = currentItem.getChildren();
            this.tabData.add(new TabItem(null, list, $this$filterTo$iv$iv2, null, 9, null));
        } else if (this.searchChildren != null && this.tabData.size() < this.displayLevel) {
            Function1<? super Item, ? extends List<Item>> function1 = this.searchChildren;
            Intrinsics.checkNotNull(function1);
            List list = (List)function1.invoke((Object)currentItem);
            if (!((Collection)list).isEmpty()) {
                tabIndex = this.tabData.size();
                int n = this.tabData.size();
                this.tabData.add(new TabItem(null, list, n, null, 9, null));
            }
        }
        if (tabIndex > -1) {
            ViewPager2 viewPager22 = this.viewPager;
            if (viewPager22 != null) {
                RecyclerView.Adapter adapter3 = viewPager22.getAdapter();
                if (adapter3 != null) {
                    adapter3.notifyItemChanged(tabIndex);
                }
            }
        }
        return tabIndex;
    }

    private static final void setData$lambda-0(CascadePickerView this$0, TabLayout.Tab tab, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        tab.setText((CharSequence)this$0.tabData.get(position).getName());
    }

    public static final /* synthetic */ int access$changeTabItem(CascadePickerView $this, TabItem tabItem) {
        return $this.changeTabItem(tabItem);
    }

    public static final /* synthetic */ void access$handlerOnClick(CascadePickerView $this, TabItem tabItem, int tabIndex) {
        $this.handlerOnClick(tabItem, tabIndex);
    }
}

