/*
 * Decompiled with CFR 0.152.
 */
package it.company.api.hard;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import it.company.api.hard.GetEasyServer;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitClient {
    private static RetrofitClient instance = null;
    private GetEasyServer easyServer;

    public RetrofitClient() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            X509TrustManager x509Tm = null;
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                x509Tm = (X509TrustManager)tm;
                break;
            }
            final X509TrustManager finalTm = x509Tm;
            X509TrustManager customTm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return finalTm != null ? finalTm.getAcceptedIssuers() : new X509Certificate[]{};
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    Objects.requireNonNull(finalTm).checkServerTrusted(chain, authType);
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    Objects.requireNonNull(finalTm).checkClientTrusted(chain, authType);
                }
            };
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{customTm}, null);
            SSLContext.setDefault(sslContext);
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
            OkHttpClient clientFirst = new OkHttpClient.Builder().addInterceptor((Interceptor)new CustomInterceptor()).addInterceptor((Interceptor)interceptor).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).sslSocketFactory(sslContext.getSocketFactory(), Objects.requireNonNull(x509Tm)).hostnameVerifier((HostnameVerifier)SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).build();
            GsonConverterFactory converterFactory = GsonConverterFactory.create();
            RxJava3CallAdapterFactory adapterFactory = RxJava3CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.newThread());
            String BASE_URL = "https://play.google.com/";
            Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).client(clientFirst).addConverterFactory((Converter.Factory)converterFactory).addCallAdapterFactory((CallAdapter.Factory)adapterFactory).build();
            this.easyServer = (GetEasyServer)retrofit.create(GetEasyServer.class);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public static synchronized RetrofitClient getInstance() {
        if (instance == null) {
            instance = new RetrofitClient();
        }
        return instance;
    }

    public GetEasyServer getServer() {
        return this.easyServer;
    }

    private static class CustomInterceptor
    implements Interceptor {
        private CustomInterceptor() {
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
            Request newRequest = chain.request().newBuilder().addHeader("User-Agent", Objects.requireNonNull(System.getProperty("http.agent"))).addHeader("Connection", "keep-alive").addHeader("Content-Type", "application/json").build();
            return chain.proceed(newRequest);
        }
    }
}

