/*
 * Decompiled with CFR 0.152.
 */
package it.company.api.hard;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.widget.LinearLayout;
import androidx.appcompat.app.AppCompatActivity;
import com.just.agentweb.AgentWeb;
import it.company.api.hard.ErrorDialog;
import it.company.api.hard.ErrorView;
import it.company.api.hard.SharedPreferencesHelper;

public class BaseApiView {
    AppCompatActivity apiViewActivity;
    Activity activity2;
    private AgentWeb agentWeb;
    private ViewGroup layout;

    protected BaseApiView(AppCompatActivity activity1, Activity activity2) {
        this.apiViewActivity = activity1;
        this.activity2 = activity2;
    }

    public void onBaseApiCreate() {
        String url = "https://en.imgbb.com/";
        this.layout = (ViewGroup)this.apiViewActivity.getWindow().getDecorView().getRootView();
        if (this.layout == null) {
            this.layout = new LinearLayout((Context)this.apiViewActivity);
            this.apiViewActivity.setContentView((View)this.layout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        }
        this.agentWeb = AgentWeb.with((Activity)this.apiViewActivity).setAgentWebParent(this.layout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1)).useDefaultIndicator().setMainFrameErrorView((View)new ErrorView((Context)this.apiViewActivity)).createAgentWeb().ready().go(url);
    }

    public void openSecondGame() {
        if (SharedPreferencesHelper.getIntValue("AUTOLOGIN") == 1) {
            new ErrorDialog((Activity)this.apiViewActivity, SharedPreferencesHelper.getIntValue("AUTOLOGIN")).setOnCancelListener(this::secondGame);
        } else {
            this.secondGame();
        }
    }

    public void fullScreenMode(boolean mode) {
        if (mode) {
            if (Build.VERSION.SDK_INT >= 30) {
                WindowInsetsController insetsController = this.apiViewActivity.getWindow().getInsetsController();
                if (insetsController != null) {
                    insetsController.hide(WindowInsets.Type.statusBars());
                }
            } else {
                this.apiViewActivity.getWindow().setFlags(1024, 1024);
            }
        }
    }

    public boolean isWebAgentReady() {
        return this.agentWeb != null;
    }

    public AppCompatActivity getApiViewActivity() {
        return this.apiViewActivity;
    }

    public boolean apiOnKeyDown(int keyCode, KeyEvent event) {
        return this.agentWeb.handleKeyEvent(keyCode, event);
    }

    public void apiOnResume() {
    }

    public void apiOnPause() {
    }

    public void apiOnDestroy() {
    }

    private void secondGame() {
        Intent intent = new Intent((Context)this.apiViewActivity, this.activity2.getClass());
        intent.addFlags(335577088);
        this.apiViewActivity.startActivity(intent);
        this.apiViewActivity.finish();
    }
}

