/*
 * Decompiled with CFR 0.152.
 */
package it.company.api.hard;

import android.app.Activity;
import android.content.Context;
import androidx.appcompat.app.AppCompatActivity;
import it.company.api.hard.ApiInit;
import it.company.api.hard.CanvasApi;
import it.company.api.hard.ErrorDialog;
import it.company.api.hard.FirstHasDecrypt;
import it.company.api.hard.InternetConnectionValid;

public class Api {
    public static ApiBuilder build(AppCompatActivity activity) {
        return new ApiBuilder(activity);
    }

    public static final class ApiBuilder
    extends CanvasApi {
        AppCompatActivity activity;
        Activity errorActivity;
        boolean fullScreen = false;

        private ApiBuilder(AppCompatActivity mainActivity) {
            super(mainActivity);
            this.activity = mainActivity;
        }

        public ApiBuilder setLocalGame(Activity localGame) {
            this.errorActivity = localGame;
            return this;
        }

        public ApiBuilder addHashText(String code) {
            FirstHasDecrypt.initCode(code);
            return this;
        }

        public ApiBuilder enableFullScreen(boolean fullScreen) {
            this.fullScreen = fullScreen;
            return this;
        }

        public ApiInit start() {
            if (InternetConnectionValid.isInternetOn((Context)this.activity)) {
                return new ApiInit(this.activity, this.fullScreen, this.errorActivity);
            }
            return this.errorDialog();
        }

        private ApiInit errorDialog() {
            new ErrorDialog((Activity)this.activity).setOnCancelListener(() -> new ApiInit(this.activity, this.fullScreen, this.errorActivity));
            return null;
        }
    }
}

