/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;

class SharedUtil {
    @NotNull
    public static final String BUFFER_PROPERTY_NAME = "space.iseki.hashutil.buffer.size";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int BUFFER_SIZE;
    static final VarHandle AVH;

    SharedUtil() {
    }

    static MessageDigest messageDigest(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> T forInputStream(MessageDigest digest, InputStream inputStream, FC<T> call) throws IOException {
        byte[] buf = new byte[BUFFER_SIZE];
        try {
            int n22;
            while ((n22 = inputStream.read(buf)) != -1) {
                digest.update(buf, 0, n22);
            }
            T n22 = SharedUtil.handleDigest(buf, digest, call);
            return n22;
        }
        catch (Throwable th) {
            try {
                digest.reset();
            }
            catch (Throwable th1) {
                th.addSuppressed(th1);
            }
            throw th;
        }
        finally {
            Arrays.fill(buf, (byte)0);
        }
    }

    static <T> T forReadableChannel(MessageDigest digest, ReadableByteChannel channel, FC<T> call) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(BUFFER_SIZE);
        byte[] arr = buf.array();
        try {
            int n22;
            while ((n22 = channel.read(buf)) != -1) {
                buf.flip();
                digest.update(buf);
                buf.clear();
            }
            T n22 = SharedUtil.handleDigest(arr, digest, call);
            return n22;
        }
        catch (Throwable th) {
            try {
                digest.reset();
            }
            catch (Throwable th1) {
                th.addSuppressed(th1);
            }
            throw th;
        }
        finally {
            buf.clear();
            Arrays.fill(arr, (byte)0);
        }
    }

    static <T> T forPath(MessageDigest digest, Path path, FC<T> call) throws IOException {
        SeekableByteChannel ch = Files.newByteChannel(path, StandardOpenOption.READ);
        IOException th = null;
        try {
            T t = SharedUtil.forReadableChannel(digest, ch, call);
            return t;
        }
        catch (IOException e) {
            th = e;
            throw th;
        }
        finally {
            try {
                ch.close();
            }
            catch (IOException e) {
                if (th == null) {
                    throw e;
                }
                th.addSuppressed(e);
                throw th;
            }
        }
    }

    static <T> T forBytes(MessageDigest digest, byte[] data, int off, int len, FC<T> call) {
        try {
            digest.update(data, off, len);
            return call.apply(digest.digest(), 0);
        }
        catch (Throwable throwable) {
            try {
                digest.reset();
            }
            catch (Throwable throwable1) {
                throwable.addSuppressed(throwable1);
            }
            throw throwable;
        }
    }

    private static <T> T handleDigest(byte[] arr, MessageDigest digest, FC<T> call) {
        try {
            digest.digest(arr, 0, digest.getDigestLength());
        }
        catch (DigestException e) {
            throw new RuntimeException(e);
        }
        return call.apply(arr, 0);
    }

    static <T> MessageDigestInterceptedInputStream<T> forInterceptedInputStream(MessageDigest digest, InputStream inputStream, FC<T> call) {
        return new MessageDigestInterceptedInputStream<T>(digest, call, inputStream);
    }

    static {
        AVH = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN).withInvokeExactBehavior();
        String p = System.getProperty(BUFFER_PROPERTY_NAME);
        BUFFER_SIZE = p == null || p.isBlank() ? 8192 : Integer.parseInt(p);
    }

    @FunctionalInterface
    static interface FC<T> {
        public T apply(byte[] var1, int var2);
    }
}

