/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.SharedUtil;

public class MessageDigestInterceptedInputStream<T>
extends InputStream {
    private final MessageDigest digest;
    private final SharedUtil.FC<T> creator;
    private final InputStream inputStream;
    private T r;

    MessageDigestInterceptedInputStream(MessageDigest digest, SharedUtil.FC<T> call, InputStream inputStream) {
        this.digest = digest;
        this.creator = call;
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        this.checkDigestIsNull();
        int n = this.inputStream.read();
        if (n != -1) {
            this.digest.update((byte)n);
        }
        return this.inputStream.read();
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        this.checkDigestIsNull();
        int n = this.inputStream.read(b, off, len);
        if (n != -1) {
            this.digest.update(b, off, n);
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.inputStream.skipNBytes(n);
    }

    public T getDigest() {
        if (this.r != null) {
            return this.r;
        }
        this.r = this.creator.apply(this.digest.digest(), 0);
        return this.r;
    }

    private void checkDigestIsNull() {
        if (this.r != null) {
            throw new IllegalStateException("digest is already created");
        }
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

