/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SHA128Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SHA128Serializer.class)
public final class SHA128
implements Comparable<SHA128> {
    private static final ThreadLocal<MessageDigest> threadLocal = SharedUtil.getThreadLocal("SHA128");
    @NotNull
    public static final SHA128 ZERO = new SHA128(0, 0, 0, 0);
    public static final int SIZE_IN_BYTES = 16;
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SHA128");
    }

    SHA128(int i0, int i1, int i2, int i3) {
        this.i0 = i0;
        this.i1 = i1;
        this.i2 = i2;
        this.i3 = i3;
    }

    public SHA128(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
    }

    public SHA128(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public SHA128(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal != null ? threadLocal.get() : SHA128.newDigest();
    }

    @NotNull
    public static MessageDigest getMessageDigest() {
        return SHA128.newDigest();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[16], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA128 t = (SHA128)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3;
    }

    public int hashCode() {
        int r = this.i0;
        r = 31 * r + this.i1;
        r = 31 * r + this.i2;
        r = 31 * r + this.i3;
        return r;
    }

    @NotNull
    public static SHA128 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SHA128.getThreadLocalDigest(), inputStream, SHA128::new);
    }

    @NotNull
    public static SHA128 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SHA128.getThreadLocalDigest(), channel, SHA128::new);
    }

    @NotNull
    public static SHA128 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SHA128.getThreadLocalDigest(), path, SHA128::new);
    }

    @NotNull
    public static SHA128 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SHA128.getThreadLocalDigest(), data, off, len, SHA128::new);
    }

    @NotNull
    public static SHA128 of(byte @NotNull [] data) {
        return SHA128.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SHA128> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SHA128.newDigest(), inputStream, SHA128::new);
    }

    @Override
    public int compareTo(@NotNull SHA128 o) {
        int r = Integer.compareUnsigned(this.i0, o.i0);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i1, o.i1);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i2, o.i2);
        if (r != 0) {
            return r;
        }
        r = Integer.compareUnsigned(this.i3, o.i3);
        if (r != 0) {
            return r;
        }
        return 0;
    }
}

