/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HexFormat;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.MessageDigestInterceptedInputStream;
import space.iseki.hashutil.SHA1Serializer;
import space.iseki.hashutil.SharedUtil;

@Serializable(with=SHA1Serializer.class)
public final class SHA1 {
    private static final ThreadLocal<MessageDigest> threadLocal = ThreadLocal.withInitial(() -> SharedUtil.messageDigest("SHA1"));
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;

    @NotNull
    private static MessageDigest newDigest() {
        return SharedUtil.messageDigest("SHA1");
    }

    public SHA1(byte @NotNull [] arr, int off) {
        this.i0 = SharedUtil.AVH.get(arr, off + 0);
        this.i1 = SharedUtil.AVH.get(arr, off + 4);
        this.i2 = SharedUtil.AVH.get(arr, off + 8);
        this.i3 = SharedUtil.AVH.get(arr, off + 12);
        this.i4 = SharedUtil.AVH.get(arr, off + 16);
    }

    public SHA1(byte @NotNull [] arr) {
        this(arr, 0);
    }

    public SHA1(@NotNull String hex) {
        this(HexFormat.of().parseHex(hex));
    }

    @NotNull
    static MessageDigest getThreadLocalDigest() {
        return threadLocal.get();
    }

    public byte @NotNull [] bytes(byte @NotNull [] arr, int off) {
        SharedUtil.AVH.set(arr, off + 0, this.i0);
        SharedUtil.AVH.set(arr, off + 4, this.i1);
        SharedUtil.AVH.set(arr, off + 8, this.i2);
        SharedUtil.AVH.set(arr, off + 12, this.i3);
        SharedUtil.AVH.set(arr, off + 16, this.i4);
        return arr;
    }

    public byte @NotNull [] bytes() {
        return this.bytes(new byte[20], 0);
    }

    @NotNull
    public String toString() {
        return HexFormat.of().formatHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA1 t = (SHA1)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4);
    }

    @NotNull
    public static SHA1 of(@NotNull InputStream inputStream) throws IOException {
        return SharedUtil.forInputStream(SHA1.getThreadLocalDigest(), inputStream, SHA1::new);
    }

    @NotNull
    public static SHA1 of(@NotNull ReadableByteChannel channel) throws IOException {
        return SharedUtil.forReadableChannel(SHA1.getThreadLocalDigest(), channel, SHA1::new);
    }

    @NotNull
    public static SHA1 of(@NotNull Path path) throws IOException {
        return SharedUtil.forPath(SHA1.getThreadLocalDigest(), path, SHA1::new);
    }

    @NotNull
    public static SHA1 of(byte @NotNull [] data, int off, int len) {
        return SharedUtil.forBytes(SHA1.getThreadLocalDigest(), data, off, len, SHA1::new);
    }

    @NotNull
    public static SHA1 of(byte @NotNull [] data) {
        return SHA1.of(data, 0, data.length);
    }

    @NotNull
    public static MessageDigestInterceptedInputStream<SHA1> intercept(@NotNull InputStream inputStream) {
        return SharedUtil.forInterceptedInputStream(SHA1.newDigest(), inputStream, SHA1::new);
    }
}

