/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.Algorithms;
import space.iseki.hashutil.Hash;
import space.iseki.hashutil.SHA256Serializer;
import space.iseki.hashutil.Util;

@Serializable(with=SHA256Serializer.class)
public final class SHA256
implements Hash {
    private final int i0;
    private final int i1;
    private final int i2;
    private final int i3;
    private final int i4;
    private final int i5;
    private final int i6;
    private final int i7;

    public SHA256(@NotNull byte[] arr, int off) {
        this.i0 = Util.getInt(arr, off + 0);
        this.i1 = Util.getInt(arr, off + 4);
        this.i2 = Util.getInt(arr, off + 8);
        this.i3 = Util.getInt(arr, off + 12);
        this.i4 = Util.getInt(arr, off + 16);
        this.i5 = Util.getInt(arr, off + 20);
        this.i6 = Util.getInt(arr, off + 24);
        this.i7 = Util.getInt(arr, off + 28);
    }

    public SHA256(@NotNull byte[] arr) {
        this(arr, 0);
    }

    public SHA256(@NotNull String hex) {
        this(Util.decodeHex(hex));
    }

    @Override
    @NotNull
    public byte[] bytes(@NotNull byte[] arr, int off) {
        Util.putInt(arr, off + 0, this.i0);
        Util.putInt(arr, off + 4, this.i1);
        Util.putInt(arr, off + 8, this.i2);
        Util.putInt(arr, off + 12, this.i3);
        Util.putInt(arr, off + 16, this.i4);
        Util.putInt(arr, off + 20, this.i5);
        Util.putInt(arr, off + 24, this.i6);
        Util.putInt(arr, off + 28, this.i7);
        return arr;
    }

    @Override
    @NotNull
    public byte[] bytes() {
        return this.bytes(new byte[32], 0);
    }

    @NotNull
    public String toString() {
        return Util.encodeHex(this.bytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA256 t = (SHA256)o;
        return this.i0 == t.i0 && this.i1 == t.i1 && this.i2 == t.i2 && this.i3 == t.i3 && this.i4 == t.i4 && this.i5 == t.i5 && this.i6 == t.i6 && this.i7 == t.i7;
    }

    @Override
    @NotNull
    public Algorithms kind() {
        return Algorithms.SHA256;
    }

    public int hashCode() {
        return Objects.hash(this.i0, this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7);
    }

    @NotNull
    public static MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA256");
    }
}

