/*
 * Decompiled with CFR 0.152.
 */
package space.iseki.hashutil;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import space.iseki.hashutil.HexUtil;

class Util {
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    static final int DEFAULT_BUFFER_SIZE = 16384;

    Util() {
    }

    public static int getInt(byte[] a, int off) {
        return INT_HANDLE.get(a, off);
    }

    public static void putInt(byte[] a, int off, int value) {
        INT_HANDLE.set(a, off, value);
    }

    @NotNull
    public static byte[] decodeHex(@NotNull String s) {
        return HexUtil.decode(s);
    }

    @NotNull
    public static String encodeHex(@NotNull byte[] a) {
        return HexUtil.encode(a);
    }

    @NotNull
    static byte[] hashStream(@NotNull MessageDigest messageDigest, @NotNull InputStream inputStream, int bufferSize) throws IOException {
        int i;
        byte[] buf = new byte[bufferSize];
        while ((i = inputStream.read(buf)) != -1) {
            messageDigest.update(buf, 0, bufferSize);
        }
        return messageDigest.digest();
    }
}

