/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.math.Vector2;

public class ShapeUtils {
    public static final float EPSILON = 0.001f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float PI_2 = 1.5707964f;
    public static final float PI_4 = 0.7853982f;
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    public static final float SQRT3 = (float)Math.sqrt(3.0);

    public static float snap(float a, float pixelSize, float halfPixelSize) {
        return (float)Math.round(a / pixelSize) * pixelSize + halfPixelSize;
    }

    public static boolean epsilonEquals(float a, float b) {
        return Math.abs(a - b) < 0.001f;
    }

    public static float normaliseAngleToPositive(float angle) {
        angle %= (float)Math.PI * 2;
        angle = (angle + (float)Math.PI * 2) % ((float)Math.PI * 2);
        return angle;
    }

    public static float floor(float x, float interval) {
        return (float)(Math.floor(x / interval) * (double)interval);
    }

    public static float ceil(float x, float interval) {
        return (float)(Math.ceil(x / interval) * (double)interval);
    }

    public static float angleRad(Vector2 v, Vector2 reference) {
        return (float)Math.atan2(reference.x * v.y - reference.y * v.x, v.x * reference.x + v.y * reference.y);
    }
}

