/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.utils.Array;
import space.earlygrey.shapedrawer.BatchManager;
import space.earlygrey.shapedrawer.PolygonBatchManager;

public class Drawing {
    BatchManager batchManager;
    Array<float[]> vertexBatches;

    Drawing(BatchManager batchManager) {
        this.batchManager = batchManager;
        this.vertexBatches = new Array();
    }

    public void draw() {
        for (int i = 0; i < this.vertexBatches.size; ++i) {
            float[] vertices = (float[])this.vertexBatches.get(i);
            this.getBatchManager().getBatch().draw(this.batchManager.r.getTexture(), vertices, 0, vertices.length);
        }
    }

    void pushVertices() {
        float[] vertices = new float[this.getBatchManager().getVerticesArrayIndex()];
        System.arraycopy(this.getBatchManager().verts, 0, vertices, 0, vertices.length);
        this.vertexBatches.add((Object)vertices);
    }

    void finalise() {
        this.vertexBatches.setSize(this.vertexBatches.size);
    }

    BatchManager getBatchManager() {
        return this.batchManager;
    }

    static class PolygonDrawing
    extends Drawing {
        Array<short[]> triangleBatches = new Array();

        PolygonDrawing(PolygonBatchManager batchManager) {
            super(batchManager);
        }

        @Override
        public void draw() {
            for (int i = 0; i < this.vertexBatches.size; ++i) {
                float[] vertices = (float[])this.vertexBatches.get(i);
                short[] triangles = (short[])this.triangleBatches.get(i);
                this.getBatchManager().getBatch().draw(this.batchManager.r.getTexture(), vertices, 0, vertices.length, triangles, 0, triangles.length);
            }
        }

        @Override
        PolygonBatchManager getBatchManager() {
            return (PolygonBatchManager)super.getBatchManager();
        }

        @Override
        void pushVertices() {
            super.pushVertices();
            short[] triangles = new short[this.getBatchManager().getTrianglesArrayOffset()];
            System.arraycopy(this.getBatchManager().triangles, 0, triangles, 0, triangles.length);
            this.triangleBatches.add((Object)triangles);
        }

        @Override
        void finalise() {
            super.finalise();
            this.triangleBatches.setSize(this.triangleBatches.size);
        }
    }
}

