/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import space.earlygrey.shapedrawer.AbstractShapeDrawer;
import space.earlygrey.shapedrawer.BatchManager;
import space.earlygrey.shapedrawer.DrawerTemplate;
import space.earlygrey.shapedrawer.JoinType;
import space.earlygrey.shapedrawer.Joiner;
import space.earlygrey.shapedrawer.ShapeUtils;

class PathDrawer
extends DrawerTemplate<BatchManager> {
    FloatArray path = new FloatArray();
    FloatArray tempPath = new FloatArray();
    static final Vector2 D0 = new Vector2();
    static final Vector2 E0 = new Vector2();

    PathDrawer(BatchManager batchManager, AbstractShapeDrawer drawer) {
        super(batchManager, drawer);
    }

    <T extends Vector2> void path(Array<T> userPath, float lineWidth, JoinType joinType) {
        this.path(userPath, lineWidth, joinType, true);
    }

    <T extends Vector2> void path(Array<T> userPath, float lineWidth, JoinType joinType, boolean open) {
        for (int i = 0; i < userPath.size; ++i) {
            Vector2 v = (Vector2)userPath.get(i);
            this.tempPath.add(v.x, v.y);
        }
        this.path(this.tempPath.items, 0, this.tempPath.size, lineWidth, joinType, open);
        this.tempPath.clear();
    }

    void path(FloatArray userPath, float lineWidth, JoinType joinType, boolean open) {
        this.path(userPath.items, 0, userPath.size, lineWidth, joinType, open);
    }

    void path(float[] userPath, float lineWidth, JoinType joinType) {
        this.path(userPath, 0, userPath.length, lineWidth, joinType);
    }

    void path(float[] userPath, float lineWidth, JoinType joinType, boolean open) {
        this.path(userPath, 0, userPath.length, lineWidth, joinType, open);
    }

    void path(float[] userPath, int start, int end, float lineWidth, JoinType joinType) {
        this.path(userPath, start, end, lineWidth, joinType, true);
    }

    void path(float[] userPath, int start, int end, float lineWidth, JoinType joinType, boolean open) {
        if (userPath.length < 4) {
            return;
        }
        this.path.add(userPath[start]);
        this.path.add(userPath[start + 1]);
        for (int i = start + 2; i < end; i += 2) {
            if (ShapeUtils.epsilonEquals(userPath[i - 2], userPath[i]) && ShapeUtils.epsilonEquals(userPath[i - 1], userPath[i + 1])) continue;
            this.path.add(userPath[i], userPath[i + 1]);
        }
        if (this.path.size < 4) {
            this.path.clear();
            return;
        }
        if (this.path.size == 4) {
            this.drawer.lineDrawer.line(this.path.items[0], this.path.items[1], this.path.items[2], this.path.items[3], lineWidth, false);
            this.path.clear();
            return;
        }
        boolean wasCaching = this.batchManager.startCaching();
        if (joinType == JoinType.NONE) {
            this.drawPathNoJoin(this.path.items, this.path.size, lineWidth, open);
        } else {
            this.drawPathWithJoin(this.path.items, this.path.size, lineWidth, open, joinType == JoinType.POINTY);
        }
        if (!wasCaching) {
            this.batchManager.endCaching();
        }
        this.path.clear();
    }

    void drawPathNoJoin(float[] path, int size, float lineWidth, boolean open) {
        int n = open ? size - 2 : size;
        for (int i = 0; i < n; i += 2) {
            this.drawer.lineDrawer.line(path[i], path[i + 1], path[(i + 2) % size], path[(i + 3) % size], lineWidth, false);
        }
    }

    void drawPathWithJoin(float[] path, int size, float lineWidth, boolean open, boolean pointyJoin) {
        float halfLineWidth = 0.5f * lineWidth;
        float c = this.batchManager.floatBits;
        this.batchManager.ensureSpaceForQuad();
        for (int i = 2; i < size - 2; i += 2) {
            float y4;
            float x4;
            float y3;
            float x3;
            A.set(path[i - 2], path[i - 1]);
            B.set(path[i], path[i + 1]);
            C.set(path[i + 2], path[i + 3]);
            if (pointyJoin) {
                Joiner.preparePointyJoin(A, B, C, D, E, halfLineWidth);
            } else {
                Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
            }
            this.vert3(D);
            this.vert4(E);
            if (i == 2) {
                if (open) {
                    Joiner.prepareFlatEndpoint(path[2], path[3], path[0], path[1], D, E, halfLineWidth);
                    this.vert1(E);
                    this.vert2(D);
                } else {
                    vec1.set(path[size - 2], path[size - 1]);
                    if (pointyJoin) {
                        Joiner.preparePointyJoin(vec1, A, B, D0, E0, halfLineWidth);
                    } else {
                        Joiner.prepareSmoothJoin(vec1, A, B, D0, E0, halfLineWidth, true);
                    }
                    this.vert1(E0);
                    this.vert2(D0);
                }
            }
            if (pointyJoin) {
                x3 = this.x3();
                y3 = this.y3();
                x4 = this.x4();
                y4 = this.y4();
            } else {
                Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
                x3 = PathDrawer.D.x;
                y3 = PathDrawer.D.y;
                x4 = PathDrawer.E.x;
                y4 = PathDrawer.E.y;
            }
            this.color(c, c, c, c);
            this.batchManager.pushQuad();
            if (!pointyJoin) {
                this.drawSmoothJoinFill(A, B, C, D, E, halfLineWidth);
            }
            this.batchManager.ensureSpaceForQuad();
            this.vert1(x4, y4);
            this.vert2(x3, y3);
        }
        if (open) {
            Joiner.prepareFlatEndpoint(B, C, D, E, halfLineWidth);
            this.vert3(E);
            this.vert4(D);
            this.color(c, c, c, c);
            this.batchManager.pushQuad();
        } else if (pointyJoin) {
            A.set(path[0], path[1]);
            Joiner.preparePointyJoin(B, C, A, D, E, halfLineWidth);
            this.vert3(D);
            this.vert4(E);
            this.color(c, c, c, c);
            this.batchManager.pushQuad();
            this.batchManager.ensureSpaceForQuad();
            this.vert1(D);
            this.vert2(E);
            this.vert3(E0);
            this.vert4(D0);
            this.color(c, c, c, c);
            this.batchManager.pushQuad();
        } else {
            A.set(B);
            B.set(C);
            C.set(path[0], path[1]);
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, false);
            this.vert3(D);
            this.vert4(E);
            this.color(c, c, c, c);
            this.batchManager.pushQuad();
            this.drawSmoothJoinFill(A, B, C, D, E, halfLineWidth);
            this.batchManager.ensureSpaceForQuad();
            Joiner.prepareSmoothJoin(A, B, C, D, E, halfLineWidth, true);
            this.vert3(E);
            this.vert4(D);
            A.set(path[2], path[3]);
            Joiner.prepareSmoothJoin(B, C, A, D, E, halfLineWidth, false);
            this.vert1(D);
            this.vert2(E);
            this.color(c, c, c, c);
            this.batchManager.pushQuad();
            this.drawSmoothJoinFill(B, C, A, D, E, halfLineWidth);
        }
    }
}

